/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T, U> Map<U, List<T>> bucket(Collection<T> c, Transformer<T, U> t) {
        HashMap<U, LinkedList<T>> buckets = new HashMap<U, LinkedList<T>>();
        for (T value : c) {
            U key = t.transform(value);
            LinkedList<T> bucket = (LinkedList<T>)buckets.get(key);
            if (bucket == null) {
                bucket = new LinkedList<T>();
                buckets.put(key, bucket);
            }
            bucket.add(value);
        }
        return buckets;
    }

    public static <T, U> void reverse(Map<T, U> source, Map<U, T> target) {
        for (T key : source.keySet()) {
            target.put(source.get(key), key);
        }
    }

    public static <T, U extends T> Collection<U> filter(Collection<U> c, Predicate<T> p) {
        Iterator<U> it = c.iterator();
        while (it.hasNext()) {
            if (p.evaluate(it.next())) continue;
            it.remove();
        }
        return c;
    }

    public static <T, U, V extends T> List<U> transform(Collection<V> c, Transformer<T, U> t) {
        ArrayList<U> result = new ArrayList<U>(c.size());
        Iterator<V> it = c.iterator();
        while (it.hasNext()) {
            result.add(t.transform(it.next()));
        }
        return result;
    }

    public static <T> Map<T, Integer> getIndexMap(List<T> list) {
        HashMap<T, Integer> indexes = new HashMap<T, Integer>();
        int index = 0;
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            indexes.put(it.next(), new Integer(index++));
        }
        return indexes;
    }
}

