/*
 * Decompiled with CFR 0.152.
 */
package iso.std.iso._20022.tech.xsd;

import com.ericsson.em.m3if.operations.validation.NotFutureDate;
import com.ericsson.em.validators.IsDateTime;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsGeographicalName;
import com.ericsson.em.validators.IsLanguage;
import com.ericsson.em.validators.IsPersonalName;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import iso.std.iso._20022.tech.xsd.CitizenshipInformation;
import iso.std.iso._20022.tech.xsd.CommunicationAddress3;
import iso.std.iso._20022.tech.xsd.CountryAndResidentialStatusType1;
import iso.std.iso._20022.tech.xsd.GenderCode;
import iso.std.iso._20022.tech.xsd.GenericIdentification9;
import iso.std.iso._20022.tech.xsd.NamePrefix1Code;
import iso.std.iso._20022.tech.xsd.PostalAddress3;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="IndividualPerson10", propOrder={"nmPrfx", "xtndedNmPrfx", "gvnNm", "mddlNm", "nm", "nmSfx", "gndr", "lang", "birthDt", "ctryOfBirth", "prvcOfBirth", "cityOfBirth", "prfssn", "taxtnCtry", "ctryAndResdtlSts", "pstlAdr", "ctznsh", "emplngCpny", "bizFctn", "pmryComAdr", "scndryComAdr", "othrId"})
public class IndividualPerson10
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="NmPrfx")
    protected NamePrefix1Code nmPrfx;
    @IsRestrictedString
    @Length(max=512)
    @XmlElement(name="XtndedNmPrfx")
    protected String xtndedNmPrfx;
    @IsFirstname
    @XmlElement(name="GvnNm")
    protected String gvnNm;
    @IsPersonalName
    @Length(max=48)
    @XmlElement(name="MddlNm")
    protected String mddlNm;
    @IsSurname
    @XmlElement(name="Nm")
    protected String nm;
    @IsRestrictedString
    @Length(max=48)
    @XmlElement(name="NmSfx")
    protected String nmSfx;
    @XmlElement(name="Gndr")
    protected GenderCode gndr;
    @IsLanguage
    @XmlElement(name="Lang")
    protected String lang;
    @Valid
    @IsDateTime(minDate="1890-01-01")
    @NotFutureDate
    @XmlElement(name="BirthDt")
    @XmlSchemaType(name="date")
    protected XMLGregorianCalendar birthDt;
    @IsGeographicalName
    @Length(max=16)
    @XmlElement(name="CtryOfBirth")
    protected String ctryOfBirth;
    @IsGeographicalName
    @Length(max=48)
    @XmlElement(name="PrvcOfBirth")
    protected String prvcOfBirth;
    @IsGeographicalName
    @Length(max=48)
    @XmlElement(name="CityOfBirth")
    protected String cityOfBirth;
    @IsRestrictedString
    @Length(max=64)
    @XmlElement(name="Prfssn")
    protected String prfssn;
    @IsGeographicalName
    @Length(max=32)
    @XmlElement(name="TaxtnCtry")
    protected String taxtnCtry;
    @Valid
    @XmlElement(name="CtryAndResdtlSts")
    protected CountryAndResidentialStatusType1 ctryAndResdtlSts;
    @Valid
    @NoNullElements
    @XmlElement(name="PstlAdr", type=PostalAddress3.class)
    protected List<PostalAddress3> pstlAdr;
    @Valid
    @NoNullElements
    @XmlElement(name="Ctznsh", type=CitizenshipInformation.class)
    protected List<CitizenshipInformation> ctznsh;
    @IsRestrictedString
    @Length(max=256)
    @XmlElement(name="EmplngCpny")
    protected String emplngCpny;
    @IsRestrictedString
    @Length(max=48)
    @XmlElement(name="BizFctn")
    protected String bizFctn;
    @Valid
    @XmlElement(name="PmryComAdr")
    protected CommunicationAddress3 pmryComAdr;
    @Valid
    @XmlElement(name="ScndryComAdr")
    protected CommunicationAddress3 scndryComAdr;
    @Valid
    @NoNullElements
    @XmlElement(name="OthrId", type=GenericIdentification9.class)
    protected List<GenericIdentification9> othrId;

    public NamePrefix1Code getNmPrfx() {
        return this.nmPrfx;
    }

    public void setNmPrfx(NamePrefix1Code value) {
        this.nmPrfx = value;
    }

    public String getXtndedNmPrfx() {
        return this.xtndedNmPrfx;
    }

    public void setXtndedNmPrfx(String value) {
        this.xtndedNmPrfx = value;
    }

    public String getGvnNm() {
        return this.gvnNm;
    }

    public void setGvnNm(String value) {
        this.gvnNm = value;
    }

    public String getMddlNm() {
        return this.mddlNm;
    }

    public void setMddlNm(String value) {
        this.mddlNm = value;
    }

    public String getNm() {
        return this.nm;
    }

    public void setNm(String value) {
        this.nm = value;
    }

    public String getNmSfx() {
        return this.nmSfx;
    }

    public void setNmSfx(String value) {
        this.nmSfx = value;
    }

    public GenderCode getGndr() {
        return this.gndr;
    }

    public void setGndr(GenderCode value) {
        this.gndr = value;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String value) {
        this.lang = value;
    }

    public XMLGregorianCalendar getBirthDt() {
        return this.birthDt;
    }

    public void setBirthDt(XMLGregorianCalendar value) {
        this.birthDt = value;
    }

    public String getCtryOfBirth() {
        return this.ctryOfBirth;
    }

    public void setCtryOfBirth(String value) {
        this.ctryOfBirth = value;
    }

    public String getPrvcOfBirth() {
        return this.prvcOfBirth;
    }

    public void setPrvcOfBirth(String value) {
        this.prvcOfBirth = value;
    }

    public String getCityOfBirth() {
        return this.cityOfBirth;
    }

    public void setCityOfBirth(String value) {
        this.cityOfBirth = value;
    }

    public String getPrfssn() {
        return this.prfssn;
    }

    public void setPrfssn(String value) {
        this.prfssn = value;
    }

    public String getTaxtnCtry() {
        return this.taxtnCtry;
    }

    public void setTaxtnCtry(String value) {
        this.taxtnCtry = value;
    }

    public CountryAndResidentialStatusType1 getCtryAndResdtlSts() {
        return this.ctryAndResdtlSts;
    }

    public void setCtryAndResdtlSts(CountryAndResidentialStatusType1 value) {
        this.ctryAndResdtlSts = value;
    }

    public List<PostalAddress3> getPstlAdr() {
        if (this.pstlAdr == null) {
            this.pstlAdr = new ArrayList<PostalAddress3>();
        }
        return this.pstlAdr;
    }

    public List<CitizenshipInformation> getCtznsh() {
        if (this.ctznsh == null) {
            this.ctznsh = new ArrayList<CitizenshipInformation>();
        }
        return this.ctznsh;
    }

    public String getEmplngCpny() {
        return this.emplngCpny;
    }

    public void setEmplngCpny(String value) {
        this.emplngCpny = value;
    }

    public String getBizFctn() {
        return this.bizFctn;
    }

    public void setBizFctn(String value) {
        this.bizFctn = value;
    }

    public CommunicationAddress3 getPmryComAdr() {
        return this.pmryComAdr;
    }

    public void setPmryComAdr(CommunicationAddress3 value) {
        this.pmryComAdr = value;
    }

    public CommunicationAddress3 getScndryComAdr() {
        return this.scndryComAdr;
    }

    public void setScndryComAdr(CommunicationAddress3 value) {
        this.scndryComAdr = value;
    }

    public List<GenericIdentification9> getOthrId() {
        if (this.othrId == null) {
            this.othrId = new ArrayList<GenericIdentification9>();
        }
        return this.othrId;
    }
}

