/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.validator;

import ericsson.vareditor.variable.TableVariableException;
import ericsson.vareditor.variable.validator.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;

public class TableVariableValidator
extends Validator {
    private Pattern myPattern;
    private Document myDocument;

    public TableVariableValidator(Pattern pattern, Document document) {
        this.myPattern = pattern;
        this.myDocument = document;
    }

    @Override
    public boolean isInputValid(String input) {
        Matcher m = this.myPattern.matcher(input);
        return m.matches();
    }

    public boolean isInputValidWithInfo(String input) throws TableVariableException {
        Matcher m;
        if (input.contains("-")) {
            String[] getInputValues = input.split("-");
            try {
                if (getInputValues.length > 2) {
                    throw new TableVariableException("Only one hyphen is allowed. (" + input + ")");
                }
                long entry0 = Long.parseLong(getInputValues[0]);
                long entry1 = Long.parseLong(getInputValues[1]);
                if (entry1 - entry0 > 1000000L) {
                    throw new TableVariableException("Range is too big. (" + input + ")");
                }
                if (entry0 > entry1) {
                    throw new TableVariableException("Range not valid. (" + input + ")");
                }
            }
            catch (NumberFormatException e) {
                throw new TableVariableException("The entry is not a number. (" + input + ")");
            }
        }
        return (m = this.myPattern.matcher(input)).matches();
    }

    public boolean isValueInModelWithInfo(String input, String model) throws TableVariableException {
        String[] inputAsString;
        if (!input.equals("") && input.contains("-") && Long.parseLong((inputAsString = input.split("-"))[0]) >= Long.parseLong(inputAsString[1])) {
            throw new TableVariableException("Range not valid. (" + input + ")");
        }
        if (!model.equals("")) {
            String[] modelAsString = model.split(",");
            for (int i = 0; i < modelAsString.length; ++i) {
                if (!this.isValueInModel(input, modelAsString[i])) continue;
                throw new TableVariableException("The entry (" + input + ") is already in the model (" + modelAsString[i] + ").");
            }
        }
        return false;
    }

    public boolean isValueInModel(String input, String model) {
        if (model.equals("")) {
            return false;
        }
        String[] modelAsString = model.split(",");
        for (int i = 0; i < modelAsString.length; ++i) {
            if (modelAsString[i].contains("-") && input.contains("-")) {
                if (!this.handleInputAndModelRange(input, modelAsString[i])) continue;
                return true;
            }
            if (modelAsString[i].contains("-")) {
                return this.handleRange(modelAsString[i], input);
            }
            if (!(input.contains("-") ? this.handleRange(input, modelAsString[i]) : modelAsString[i].startsWith(input) || input.startsWith(modelAsString[i]))) continue;
            return true;
        }
        return false;
    }

    private boolean handleRange(String rangeString, String inputString) {
        String[] rangeValue = rangeString.split("-");
        long rangeValue0 = Long.parseLong(rangeValue[0]);
        long rangeValue1 = Long.parseLong(rangeValue[1]);
        int prefixCount = rangeValue[0].length() - Long.toString(rangeValue0).length();
        String prefix = "";
        for (int k = 0; k < prefixCount; ++k) {
            prefix = prefix + "0";
        }
        String inputWithPrefix = "";
        while (rangeValue0 <= rangeValue1) {
            double l = Math.log10(rangeValue0);
            double diff = l - Math.floor(l);
            if (Math.abs(diff) <= Double.MIN_VALUE && !prefix.equals("")) {
                prefix = prefix.substring(1);
            }
            if ((inputWithPrefix = prefix + Long.toString(rangeValue0)).startsWith(inputString) || inputString.startsWith(inputWithPrefix)) {
                return true;
            }
            ++rangeValue0;
        }
        return false;
    }

    private boolean handleInputAndModelRange(String inputString, String modelString) {
        String[] inputValue = inputString.split("-");
        long inputValue0 = Long.parseLong(inputValue[0]);
        long inputValue1 = Long.parseLong(inputValue[1]);
        int prefixCount = inputValue[0].length() - Long.toString(inputValue0).length();
        String prefix = "";
        for (int k = 0; k < prefixCount; ++k) {
            prefix = prefix + "0";
        }
        String inputWithPrefix = "";
        while (inputValue0 <= inputValue1) {
            double l = Math.log10(inputValue0);
            double diff = l - Math.floor(l);
            if (Math.abs(diff) <= Double.MIN_VALUE && !prefix.equals("")) {
                prefix = prefix.substring(1);
            }
            if (this.isValueInModel(inputWithPrefix = prefix + Long.toString(inputValue0), modelString)) {
                return true;
            }
            ++inputValue0;
        }
        return false;
    }

    public Document getDocument() {
        return this.myDocument;
    }
}

