/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldDefs;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TreeDefinedFieldXmlUtil {
    private TreeDefinedFieldHelper myTDFHelper;

    public TreeDefinedFieldXmlUtil(TreeDefinedFieldHelper theHelper) {
        this.myTDFHelper = theHelper;
    }

    public List<Variable> getAdditionalVarsFromXml(Element fieldElement) {
        ArrayList<Variable> additionalList = new ArrayList<Variable>();
        NodeList additionalComponents = fieldElement.getElementsByTagName("AdditionalVar");
        int length = additionalComponents.getLength();
        for (int i = 0; i < length; ++i) {
            Element additionalElement = (Element)additionalComponents.item(i);
            if (additionalElement.getNodeType() != 1) continue;
            String dataType = additionalElement.getAttribute("DataType");
            String name = TreeDefinedFieldXmlUtil.getNameAttribute(additionalElement);
            Variable var = this.myTDFHelper.getTDFAdditionalVariableOfDataType(dataType, name, additionalElement);
            var.setValue(TreeDefinedFieldXmlUtil.getValueAttribute(additionalElement));
            additionalList.add(var);
        }
        return additionalList;
    }

    public static String getMinValueForRangeEditor(Element editComponentElement) {
        NodeList rangeComponents = editComponentElement.getElementsByTagName("Range");
        int rangeLength = rangeComponents.getLength();
        for (int jj = 0; jj < rangeLength; ++jj) {
            Element rangeNode = (Element)rangeComponents.item(jj);
            if (rangeNode.getNodeType() != 1 || !rangeNode.hasAttributes()) continue;
            return rangeNode.getAttribute("Min");
        }
        return null;
    }

    public static String getMaxValueForRangeEditor(Element editComponentElement) {
        NodeList rangeComponents = editComponentElement.getElementsByTagName("Range");
        int rangeLength = rangeComponents.getLength();
        for (int jj = 0; jj < rangeLength; ++jj) {
            Element rangeNode = (Element)rangeComponents.item(jj);
            if (rangeNode.getNodeType() != 1 || !rangeNode.hasAttributes()) continue;
            return rangeNode.getAttribute("Max");
        }
        return null;
    }

    public static ArrayModel getEnumArrayForEditor(Element editComponentElement, DataType dataType) {
        NodeList editComponents = editComponentElement.getElementsByTagName("Enum");
        int len = editComponents.getLength();
        Object[] valueArray = new Object[2];
        Object[] valuesArray = dataType.createArray(len);
        String[] namesArray = new String[len];
        for (int jj = 0; jj < len; ++jj) {
            Element enumElement = (Element)editComponents.item(jj);
            if (enumElement.getNodeType() != 1) continue;
            namesArray[jj] = TreeDefinedFieldXmlUtil.getNameAttribute(enumElement);
            valuesArray[jj] = dataType.parseValue(TreeDefinedFieldXmlUtil.getValueAttribute(enumElement));
        }
        valueArray[0] = namesArray;
        valueArray[1] = valuesArray;
        return new ArrayModel(valueArray, TreeDefinedFieldDefs.COLUMN_NAMES);
    }

    private static String getNameAttribute(Element e) {
        return e.hasAttribute("name") ? e.getAttribute("name") : e.getAttribute("Name");
    }

    private static String getValueAttribute(Element e) {
        return e.hasAttribute("value") ? e.getAttribute("value") : e.getAttribute("Value");
    }

    public static Element getEditComponent(Element fieldElement) {
        NodeList editComponents = fieldElement.getElementsByTagName("EditComponent");
        NodeList inputRestrictionComponents = fieldElement.getElementsByTagName("InputRestriction");
        if (editComponents.getLength() > 0) {
            Element e = (Element)editComponents.item(0);
            if (inputRestrictionComponents.getLength() > 0) {
                for (int j = 0; j < inputRestrictionComponents.getLength(); ++j) {
                    e.appendChild(inputRestrictionComponents.item(j));
                }
            }
            return e;
        }
        if (inputRestrictionComponents.getLength() > 0) {
            return (Element)inputRestrictionComponents.item(0);
        }
        return null;
    }
}

