/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TDFAdditionalDataType;
import com.ericsson.ere.util.CollectionUtils;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.treedefinedfields.AbstractTDFAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldExportAction;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFAdditionalObject;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class TreeDefinedFieldImportAction
extends AbstractTDFAction {
    private static final String IMPORT_ICON_FILE = "import1_16.png";

    public TreeDefinedFieldImportAction(ClassRepository repository, List<TreeDefinedField> model, List<TDFAdditionalDataType> additionalDataTypes) {
        super(repository, model, null, additionalDataTypes);
        this.putValue("SmallIcon", RmaDefs.getImageIcon(IMPORT_ICON_FILE));
        this.putValue("ShortDescription", "Import file containing 'Tree Defined Field'(s)");
    }

    public TreeDefinedFieldImportAction(ClassRepository repository, List<TreeDefinedField> model, List<TDFAdditionalObject> additionalVarList, List<TDFAdditionalDataType> additionalDataTypes) {
        super(repository, model, additionalVarList, additionalDataTypes);
        this.putValue("SmallIcon", RmaDefs.getImageIcon(IMPORT_ICON_FILE));
        this.putValue("ShortDescription", "Import file containing 'Tree Defined Field'(s)");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<String> existingTDFs = new ArrayList<String>(CollectionUtils.transform(this.myModel, TreeDefinedFieldExportAction.TDF_NAME_TRANSFORMER));
        Map<String, Element> resultingTDFs = this.importFields(existingTDFs);
        this.addImportedFieldsToModel(resultingTDFs);
    }

    protected Map<String, Element> importFields(List<String> existingTDFs) {
        HashMap<String, Element> resultingTDFs = new HashMap<String, Element>();
        WizardView tDialog = WizardFactory.createTDFImportWizard(existingTDFs, this.getUsedTDFNames(), this.myRepository, resultingTDFs);
        tDialog.run();
        return resultingTDFs;
    }

    private void addImportedFieldsToModel(Map<String, Element> resultingTDFs) {
        for (Map.Entry<String, Element> entry : new TreeMap<String, Element>(resultingTDFs).entrySet()) {
            TreeDefinedField tdf = this.createTreeDefinedField(entry.getValue());
            int foundAtIndex = -1;
            for (int i = 0; i < this.myModel.size(); ++i) {
                if (!((TreeDefinedField)this.myModel.get(i)).toString().equals(entry.getKey())) continue;
                this.myModel.set(i, tdf);
                foundAtIndex = i;
                break;
            }
            if (foundAtIndex != -1) continue;
            this.myModel.add(tdf);
        }
    }

    private TreeDefinedField createTreeDefinedField(Element field) {
        TreeDefinedField tdf = new TreeDefinedField(this.myRepository, field, this.myAdditionalDataTypesList, this.myAdditionalVarList);
        return tdf;
    }
}

