/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.SwingWorker;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.VariablePanelListener;
import ericsson.vareditor.variable.bitpatternutils.BitPatternPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.w3c.dom.Node;

public class SimpleBitPatternVariablePanel
extends AbstractPanelVariableEditor
implements ActionListener {
    private JTextField myDecimalTF;
    protected BitPatternPanel myEditPanel;
    protected JDialog myEditDialog;
    private JButton editButton = new JButton("Edit");
    private static SimpleBitPatternEditAction editAction = null;
    public static final String EDIT_ICON_FILE = "new_edit.gif";
    protected static final String LBL_DIALOG_TITLE = "Bit pattern value";
    private DataType myDataType;

    public SimpleBitPatternVariablePanel(DataType dataType) {
        this.myDataType = dataType;
        this.init();
    }

    public SimpleBitPatternVariablePanel(String value, DataType dataType) {
        this(dataType);
        this.myDecimalTF.setText(value);
    }

    private void init() {
        JFrame frame = GuiServiceCenter.getInstance().getMainWindow();
        this.myEditDialog = new JDialog(frame, LBL_DIALOG_TITLE, true);
        this.myEditDialog.setMinimumSize(new Dimension(600, 285));
        this.buildPanel();
        this.setVisible(true);
        this.myEditPanel = new BitPatternPanel("0", this.myDataType, false);
        this.myEditPanel.addOkActionListener(this);
        this.myEditPanel.addCancelActionListener(this);
        this.myEditDialog.getContentPane().add(this.myEditPanel);
        this.myEditDialog.pack();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.createDecimalTextField();
        this.createEditButton();
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    private void createDecimalTextField() {
        this.myDecimalTF = new JTextField(){

            @Override
            public boolean isEditable() {
                return false;
            }
        };
        this.myDecimalTF.setColumns(25);
        this.myDecimalTF.setHorizontalAlignment(4);
        this.myDecimalTF.setBackground(Color.WHITE);
        this.add((Component)this.myDecimalTF, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createEditButton() {
        this.initActions();
        this.editButton.setIcon(RmaDefs.getImageIcon(EDIT_ICON_FILE));
        this.editButton.addActionListener(editAction);
        this.editButton.setToolTipText("Edit the Bit pattern value");
        this.add((Component)this.editButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initActions() {
        editAction = new SimpleBitPatternEditAction();
        InputMap input = this.getInputMap();
        ActionMap action = this.getActionMap();
        input.put(KeyStroke.getKeyStroke(69, 128), "edit");
        action.put("edit", editAction);
        this.setInputMap(1, input);
        this.setActionMap(action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.myDecimalTF.setText(this.myEditPanel.getValue());
            this.fireDataChanged();
        }
        this.myEditDialog.setVisible(false);
        this.myEditPanel.setFirstComponentFocus();
        this.myEditPanel.reset();
    }

    public void writeXML(PrintWriter out) {
        out.print("<Value>");
        out.print(this.getValueString());
        out.print("</Value>");
    }

    public void initFromXml(Node node, String value) {
        this.setValue(value);
    }

    public String getValueString() {
        return this.myDecimalTF.getText();
    }

    public Object getValueObject() {
        return this.myDecimalTF.getText();
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueValid(String value) {
        try {
            if (this.myDataType.equals(DataType.SHORT)) {
                Short.parseShort(value);
            } else if (this.myDataType.equals(DataType.INTEGER)) {
                Integer.parseInt(value);
            } else {
                Long.parseLong(value);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public void setValue(String values) {
        this.myDecimalTF.setText(values);
    }

    @Override
    public void setEditorListener(VariablePanelListener parListener) {
        super.setEditorListener(parListener);
    }

    @Override
    public boolean isEditorValueValid() {
        return this.isValueValid();
    }

    @Override
    public Object getEditorValue() {
        return this.getValueString();
    }

    @Override
    public Component getEditorComponent(Variable parVariable) {
        this.setValue(parVariable.getValueString());
        return super.getEditorComponent(parVariable);
    }

    public class SimpleBitPatternEditAction
    extends AbstractAction {
        public SimpleBitPatternEditAction() {
            super("Edit value");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    SimpleBitPatternVariablePanel.this.myEditPanel.reset();
                    SimpleBitPatternVariablePanel.this.myEditPanel.setValue(SimpleBitPatternVariablePanel.this.myDecimalTF.getText());
                    SimpleBitPatternVariablePanel.this.myEditDialog.setTitle("Bit pattern value - Edit");
                    SimpleBitPatternVariablePanel.this.myEditDialog.setVisible(true);
                    return new Object();
                }

                @Override
                public void finished() {
                }
            };
            worker.start();
        }
    }
}

