/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.VariablePanelListener;
import ericsson.vareditor.variable.bitpatternutils.BPListObject;
import ericsson.vareditor.variable.bitpatternutils.BitPatternAddAction;
import ericsson.vareditor.variable.bitpatternutils.BitPatternDeleteAction;
import ericsson.vareditor.variable.bitpatternutils.BitPatternEditAction;
import ericsson.vareditor.variable.bitpatternutils.BitPatternEditMenu;
import ericsson.vareditor.variable.bitpatternutils.BitPatternPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.w3c.dom.Node;

public class BitPatternVariablePanel
extends AbstractPanelVariableEditor
implements ActionListener,
MouseListener,
ListDataListener {
    private int hGap = 5;
    public static final String VALUE_SEP = ",";
    private JPanel myButtonPanel = new JPanel();
    private JList myList;
    private DefaultListModel myModel = new DefaultListModel();
    protected BitPatternPanel myEditPanel;
    protected JDialog myEditDialog;
    private BitPatternEditMenu myPopupMenu;
    private JButton addButton = new JButton("Add");
    private JButton editButton = new JButton("Edit");
    private JButton deleteButton = new JButton("Delete");
    private static BitPatternAddAction addAction = null;
    private static BitPatternEditAction editAction = null;
    private static BitPatternDeleteAction deleteAction = null;
    public static final String ADD_ICON_FILE = "new_add.gif";
    public static final String EDIT_ICON_FILE = "new_edit.gif";
    public static final String DELETE_ICON_FILE = "new_delete.gif";
    protected static final int ACTION_ADD = 0;
    protected static final int ACTION_EDIT = 1;
    protected static final int ACTION_DELETE = 2;
    private int currentAction = 0;
    protected static final String LBL_DIALOG_TITLE = "Bit pattern value";
    private DataType myDataType;

    public BitPatternVariablePanel(DataType dataType) {
        this.myDataType = dataType;
        this.init();
        this.myPopupMenu = new BitPatternEditMenu(addAction, editAction, deleteAction);
    }

    public BitPatternVariablePanel(String value, DataType dataType) {
        this(dataType);
        this.setValuesInList(value);
    }

    private void init() {
        JFrame frame = GuiServiceCenter.getInstance().getMainWindow();
        this.myEditDialog = new JDialog(frame, LBL_DIALOG_TITLE, true);
        this.myEditDialog.setMinimumSize(new Dimension(600, 285));
        this.buildObjectListPanel();
        this.setVisible(true);
        this.myEditPanel = new BitPatternPanel("0", this.myDataType);
        this.myEditPanel.addOkActionListener(this);
        this.myEditPanel.addCancelActionListener(this);
        this.myEditDialog.getContentPane().add(this.myEditPanel);
        this.myEditDialog.pack();
    }

    private void setValuesInList(String valueStr) {
        if (valueStr.equals("")) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(valueStr, VALUE_SEP);
        while (tokenizer.hasMoreTokens()) {
            this.myModel.addElement(new BPListObject(tokenizer.nextToken(), this.myDataType));
        }
    }

    private void buildObjectListPanel() {
        this.setLayout(new BorderLayout());
        this.myList = new JList(this.myModel);
        this.myList.setVisibleRowCount(5);
        this.myList.setFixedCellHeight(18);
        this.myList.addMouseListener(this);
        this.add((Component)new JScrollPane(this.myList), "Center");
        this.createButtonPanel();
        this.add((Component)this.myButtonPanel, "South");
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    private void createButtonPanel() {
        this.initActions();
        this.addButton.setIcon(RmaDefs.getImageIcon(ADD_ICON_FILE));
        this.editButton.setIcon(RmaDefs.getImageIcon(EDIT_ICON_FILE));
        this.deleteButton.setIcon(RmaDefs.getImageIcon(DELETE_ICON_FILE));
        this.addButton.addActionListener(addAction);
        this.editButton.addActionListener(editAction);
        this.deleteButton.addActionListener(deleteAction);
        this.addButton.setToolTipText("Add a Bit pattern value");
        this.editButton.setToolTipText("Edit the selected Bit pattern value");
        this.deleteButton.setToolTipText("Delete the selected Bit pattern value");
        this.myButtonPanel.setLayout(new BoxLayout(this.myButtonPanel, 0));
        this.myButtonPanel.add(Box.createHorizontalGlue());
        this.myButtonPanel.add(this.addButton);
        this.myButtonPanel.add(Box.createHorizontalStrut(this.hGap));
        this.myButtonPanel.add(this.editButton);
        this.myButtonPanel.add(Box.createHorizontalStrut(this.hGap));
        this.myButtonPanel.add(this.deleteButton);
        this.myButtonPanel.add(Box.createHorizontalStrut(this.hGap));
        this.myButtonPanel.add(Box.createHorizontalGlue());
    }

    private void initActions() {
        addAction = new BitPatternAddAction(this);
        editAction = new BitPatternEditAction(this);
        deleteAction = new BitPatternDeleteAction(this);
        InputMap input = this.myList.getInputMap();
        ActionMap action = this.myList.getActionMap();
        input.put(KeyStroke.getKeyStroke(65, 128), "Add value");
        action.put("Add value", addAction);
        input.put(KeyStroke.getKeyStroke(69, 128), "edit");
        action.put("edit", editAction);
        input.put(KeyStroke.getKeyStroke(127, 128), "delete");
        action.put("delete", deleteAction);
        this.myList.setInputMap(0, input);
        this.myList.setActionMap(action);
    }

    public void setCurrentAction(int action) {
        this.currentAction = action;
    }

    public int getCurrentaction() {
        return this.currentAction;
    }

    public JList getList() {
        return this.myList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int indexToBeSelected = this.myList.getSelectedIndex();
        if (e.getActionCommand().equals("OK")) {
            BPListObject value = new BPListObject(this.myEditPanel.getValue(), this.myDataType);
            if (!this.myEditPanel.valueValid()) {
                DialogFactory.getErrorDialog(this.myEditPanel, "Incorrect definition of range", "End value must be greater than start value.\nPlease correct this and try again.");
                return;
            }
            if (this.currentAction == 1) {
                this.myModel.setElementAt(value, this.myList.getSelectedIndex());
            } else if (this.currentAction == 0) {
                this.myModel.addElement(value);
                indexToBeSelected = this.myModel.size() - 1;
            }
        }
        this.myEditPanel.setFirstComponentFocus();
        this.myEditDialog.setVisible(false);
        this.myList.setSelectedIndex(indexToBeSelected);
        this.myList.requestFocus();
        this.myEditPanel.reset();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeViewPopupMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeViewPopupMenu(e);
    }

    private void maybeViewPopupMenu(MouseEvent e) {
        int selRow;
        if (!(e.getSource() instanceof JList)) {
            return;
        }
        JList source = (JList)e.getSource();
        if (!this.myPopupMenu.isVisible() && (selRow = source.locationToIndex(new Point(e.getX(), e.getY()))) != -1) {
            source.setSelectedIndex(selRow);
        }
        this.myPopupMenu.enableAction(source.getSelectedValues().length);
        if (e.isPopupTrigger()) {
            this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public Object getModel() {
        return this.myModel;
    }

    public void writeXML(PrintWriter out) {
        out.print("<Value>");
        out.print(this.getValueString());
        out.print("</Value>");
    }

    public void initFromXml(Node node, String value) {
        this.setValue(value, false);
    }

    public String getValueString() {
        StringBuffer valueString = new StringBuffer();
        for (int i = 0; i < this.myModel.size(); ++i) {
            valueString.append(((BPListObject)this.myModel.get(i)).sourceString() + VALUE_SEP);
        }
        return valueString.toString();
    }

    public Object getValueObject() {
        return this.myModel;
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueValid(String value) {
        try {
            if (this.myDataType.equals(DataType.SHORT)) {
                Short.parseShort(value);
            } else if (this.myDataType.equals(DataType.INTEGER)) {
                Integer.parseInt(value);
            } else {
                Long.parseLong(value);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public void setValue(String values, boolean resetModel) {
        if (resetModel) {
            this.myModel.removeAllElements();
            this.setValuesInList(values);
            this.fireDataChanged();
        } else if (this.myModel.isEmpty()) {
            this.setValuesInList(values);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void setEditorListener(VariablePanelListener parListener) {
        super.setEditorListener(parListener);
        if (this.myModel != null) {
            this.myModel.addListDataListener(this);
        }
    }

    @Override
    public boolean isEditorValueValid() {
        return this.isValueValid();
    }

    @Override
    public Object getEditorValue() {
        return this.getValueString();
    }

    @Override
    public Component getEditorComponent(Variable parVariable) {
        this.setValue(parVariable.getValueString(), false);
        return super.getEditorComponent(parVariable);
    }

    public String getDisplayableValueString() {
        StringBuffer valueString = new StringBuffer();
        for (int i = 0; i < this.myModel.size(); ++i) {
            valueString.append(((BPListObject)this.myModel.get(i)).getValueString(false)).append(VALUE_SEP);
        }
        return valueString.toString();
    }
}

