/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.datatype.DataType;
import ericsson.ere.gui.StatusPanel;
import ericsson.vareditor.variable.bitpatternutils.BitPatternData;
import ericsson.vareditor.variable.bitpatternutils.BitPatternView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BitPatternPanel
extends JPanel {
    private static Logger log = Logger.getLogger(BitPatternPanel.class.getName());
    private BitPatternData myBPData;
    private JPanel editPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JCheckBox defineRangeChB;
    private StatusPanel myStatusPanel = StatusPanel.getNewInstance();
    private BitPatternView bpv;
    private BitPatternView bpv2;
    private boolean allowRanges = true;

    public BitPatternPanel(String aValue, DataType dataType) {
        this(aValue, dataType, true);
    }

    public BitPatternPanel(String aValue, DataType dataType, boolean ranges) {
        this.setName("BitPatternPanel");
        this.allowRanges = ranges;
        this.bpv = new BitPatternView(dataType, this.myStatusPanel);
        this.bpv2 = new BitPatternView(dataType, this.myStatusPanel);
        this.bpv2.setScrollModel(this.bpv.getScrollModel());
        this.myBPData = new BitPatternData(dataType);
        this.setLayout(new BorderLayout());
        this.add((Component)this.initComponents(), "Center");
        this.add((Component)this.myStatusPanel, "South");
        try {
            this.myBPData.setData(aValue);
            this.setupComponents();
            this.populate();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public String getValue() {
        String value = "Not defined (error)";
        try {
            value = this.myBPData.isRange() ? this.bpv.getData() + "-" + this.bpv2.getData() : this.bpv.getData();
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
        return value;
    }

    public void setValue(String aValue) {
        try {
            this.myBPData.setData(aValue);
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
        this.populate();
    }

    public void reset() {
        this.myBPData.isRange(false);
        this.defineRangeChB.setSelected(false);
        this.setValue("0");
        this.populate();
    }

    public boolean valueValid() {
        if (this.myBPData.isRange()) {
            return new BigInteger(this.bpv.getData()).compareTo(new BigInteger(this.bpv2.getData())) < 0;
        }
        return true;
    }

    public void addOkActionListener(ActionListener aListener) {
        this.okButton.addActionListener(aListener);
    }

    public void removeOkActionListener(ActionListener aListener) {
        this.okButton.removeActionListener(aListener);
    }

    public void addCancelActionListener(ActionListener aListener) {
        this.cancelButton.addActionListener(aListener);
    }

    public void removeCancelActionListener(ActionListener aListener) {
        this.cancelButton.removeActionListener(aListener);
    }

    private JPanel initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.defineRangeChB = new JCheckBox();
        this.defineRangeChB.setName("BitPatternPanel.JCheckBox.DefineRange");
        this.defineRangeChB.setText("Define a range");
        this.defineRangeChB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BitPatternPanel.this.defineRangeChBItemStateChanged(evt);
                BitPatternPanel.this.setFirstComponentFocus();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        if (this.allowRanges) {
            panel.add((Component)this.defineRangeChB, gridBagConstraints);
        } else {
            JLabel placeHolder = new JLabel();
            placeHolder.setName("BitPatternPanel.JLabel.DefineRangePlaceHolder");
            panel.add((Component)placeHolder, gridBagConstraints);
        }
        this.okButton = new JButton();
        this.okButton.setName("BitPatternPanel.JButton.Ok");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BitPatternPanel.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        panel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton = new JButton();
        this.cancelButton.setName("BitPatternPanel.JButton.Cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BitPatternPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        panel.add((Component)this.cancelButton, gridBagConstraints);
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)this.editPanel, gridBagConstraints);
        return panel;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.myStatusPanel.setStatusMsg("");
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.myStatusPanel.setStatusMsg("");
    }

    private void defineRangeChBItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.bpv.reset();
            this.bpv2.reset();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(5, 5, 5, 10);
            gbc.anchor = 12;
            gbc.weightx = 1.0;
            this.bpv2.setTitle("Bit pattern range, end value");
            this.bpv2.maskEnabled(false);
            this.bpv.setTitle("Bit pattern range, start value");
            this.bpv.maskEnabled(false);
            this.editPanel.add((Component)this.bpv2, gbc);
            this.myBPData.isRange(true);
            this.validate();
        } else {
            this.bpv.reset();
            this.bpv2.reset();
            this.editPanel.remove(this.bpv2);
            this.bpv.setTitle("Bit pattern value");
            this.bpv.maskEnabled(true);
            this.myBPData.isRange(false);
            this.validate();
        }
        this.myStatusPanel.setStatusMsg("");
    }

    private void setupComponents() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 10);
        gbc.anchor = 12;
        this.editPanel.add((Component)this.bpv, gbc);
        this.editPanel.setMinimumSize(this.getPreferredSize());
        Vector<JButton> buttonVector = new Vector<JButton>();
        buttonVector.add(this.okButton);
        buttonVector.add(this.cancelButton);
        this.okButton.setMinimumSize(this.okButton.getPreferredSize());
        this.cancelButton.setMinimumSize(this.cancelButton.getPreferredSize());
    }

    private void populate() {
        this.bpv.maskEnabled(true);
        if (this.myBPData.isRange()) {
            this.defineRangeChB.setSelected(true);
            this.bpv.maskEnabled(false);
            this.bpv2.maskEnabled(false);
        }
        this.bpv.setData(this.myBPData.getFromValue());
        this.bpv2.setData(this.myBPData.getToValue());
    }

    public void setFirstComponentFocus() {
        this.bpv.setFirstComponentFocus();
    }

    public StatusPanel getStatusPanel() {
        return this.myStatusPanel;
    }
}

