/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.vareditor.variable.BitPatternInputVariable;
import ericsson.vareditor.variable.Variable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class BitPatternEditor
implements XMLInitializable,
SimulationEditor {
    private static final Map<DataType, Integer> DATATYPE_MAPPING = new HashMap<DataType, Integer>();
    private FieldDefinition myField;
    private DataType myDataType;
    private static final String MAX_USHORT = "65535";
    private static final String MAX_UINT = "4294967295";
    private static final String MAX_ULONG = "18446744073709551615";

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        return this;
    }

    public static boolean isDataTypeSupported(DataType dataType) {
        return DATATYPE_MAPPING.containsKey(dataType);
    }

    @Override
    public Variable createVariable() {
        String defaultString;
        String name = this.myField.getFieldName();
        String string = defaultString = this.myField.hasDefaultValue() ? this.myField.getDefaultValue() : "0";
        if (!DATATYPE_MAPPING.containsKey(this.myDataType)) {
            throw new IllegalStateException("Unhandled datatype in BitPatternEditor: " + this.myDataType.getTypeName());
        }
        int type = DATATYPE_MAPPING.get(this.myDataType);
        BitPatternInputVariable var = new BitPatternInputVariable(name, defaultString, type);
        return var;
    }

    @Override
    public String getEditStringForValue(String value) {
        return value;
    }

    @Override
    public String getValueForEditString(String editString) {
        return editString;
    }

    @Override
    public boolean isValidEditString(String editString) {
        return this.isValidValueString(editString);
    }

    @Override
    public boolean isValidValueString(String value) {
        try {
            if (this.myDataType == DataType.SHORT) {
                Short.parseShort(value);
                return true;
            }
            if (this.myDataType == DataType.UNSIGNEDSHORT) {
                if (new BigInteger(value).compareTo(new BigInteger(MAX_USHORT)) <= 0 && new BigInteger(value).compareTo(BigInteger.ZERO) >= 0) {
                    return true;
                }
            } else {
                if (this.myDataType == DataType.INTEGER) {
                    Integer.parseInt(value);
                    return true;
                }
                if (this.myDataType == DataType.UNSIGNEDINT) {
                    if (new BigInteger(value).compareTo(new BigInteger(MAX_UINT)) <= 0 && new BigInteger(value).compareTo(BigInteger.ZERO) >= 0) {
                        return true;
                    }
                } else {
                    if (this.myDataType == DataType.LONG) {
                        Long.parseLong(value);
                        return true;
                    }
                    if (this.myDataType == DataType.UNSIGNEDLONG && new BigInteger(value).compareTo(new BigInteger(MAX_ULONG)) <= 0 && new BigInteger(value).compareTo(BigInteger.ZERO) >= 0) {
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void setFieldDefinition(FieldDefinition f) {
        this.myField = f;
        this.myDataType = f.getTypedDataType();
    }

    static {
        DATATYPE_MAPPING.put(DataType.SHORT, 0);
        DATATYPE_MAPPING.put(DataType.UNSIGNEDSHORT, 3);
        DATATYPE_MAPPING.put(DataType.INTEGER, 1);
        DATATYPE_MAPPING.put(DataType.UNSIGNEDINT, 4);
        DATATYPE_MAPPING.put(DataType.LONG, 2);
        DATATYPE_MAPPING.put(DataType.UNSIGNEDLONG, 5);
    }
}

