/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.bitpatternutils.BitPatternAddAction;
import ericsson.vareditor.variable.bitpatternutils.BitPatternDeleteAction;
import ericsson.vareditor.variable.bitpatternutils.BitPatternEditAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class BitPatternEditMenu
extends JPopupMenu {
    public static final String ADD_ICON_FILE = "new_add.gif";
    public static final String DELETE_ICON_FILE = "new_delete.gif";
    public static final String EDIT_ICON_FILE = "new_edit.gif";
    private JMenuItem actionAdd;
    private JMenuItem actionEdit;
    private JMenuItem actionDelete;
    private static BitPatternAddAction addAction = null;
    private static BitPatternEditAction editAction = null;
    private static BitPatternDeleteAction deleteAction = null;

    public BitPatternEditMenu(BitPatternAddAction add, BitPatternEditAction edit, BitPatternDeleteAction delete) {
        addAction = add;
        editAction = edit;
        deleteAction = delete;
        this.setup();
    }

    private void setup() {
        this.actionAdd = this.createAddValueItem();
        this.actionEdit = this.createEditValueItem();
        this.actionDelete = this.createDeleteValueItem();
        this.add(this.actionAdd);
        this.add(this.actionEdit);
        this.addSeparator();
        this.add(this.actionDelete);
    }

    private JMenuItem createAddValueItem() {
        JMenuItem aMenuItem = new JMenuItem();
        ImageIcon aIcon = RmaDefs.getImageIcon(ADD_ICON_FILE);
        aMenuItem.setAction(addAction);
        aMenuItem.setIcon(aIcon);
        return aMenuItem;
    }

    private JMenuItem createEditValueItem() {
        JMenuItem aMenuItem = new JMenuItem();
        ImageIcon aIcon = RmaDefs.getImageIcon(EDIT_ICON_FILE);
        aMenuItem.setAction(editAction);
        aMenuItem.setIcon(aIcon);
        return aMenuItem;
    }

    private JMenuItem createDeleteValueItem() {
        JMenuItem aMenuItem = new JMenuItem();
        ImageIcon aIcon = RmaDefs.getImageIcon(DELETE_ICON_FILE);
        aMenuItem.setAction(deleteAction);
        aMenuItem.setIcon(aIcon);
        return aMenuItem;
    }

    public void enableAction(int noSelectedItem) {
        this.actionAdd.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionDelete.setEnabled(true);
        if (noSelectedItem > 1) {
            this.actionEdit.setEnabled(false);
        }
        if (noSelectedItem < 1) {
            this.actionEdit.setEnabled(false);
            this.actionDelete.setEnabled(false);
        }
    }
}

