/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import com.ericsson.ere.annotations.jcip.Immutable;
import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.bitpatternutils.BitPatternValue;
import java.math.BigInteger;
import java.util.StringTokenizer;

@Immutable
public final class BPListObject {
    private final String myListRepresentation;
    private final String mySourceStr;
    private final DataType myDataType;

    public BPListObject(String aObj, DataType dataType) {
        this.mySourceStr = aObj;
        this.myDataType = dataType;
        this.myListRepresentation = this.parseValues();
    }

    private String parseValues() {
        return this.getValueString(false) + " (Hex " + this.getValueString(true) + ")";
    }

    String getValueString(boolean asHex) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mySourceStr.indexOf("-") != -1) {
            this.handleRange(asHex, stringBuilder);
        } else if (this.mySourceStr.indexOf(";") != -1) {
            this.handleValueMask(asHex, stringBuilder);
        } else {
            this.handleSingleValue(this.mySourceStr, asHex, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void handleSingleValue(String valueString, boolean asHex, StringBuilder stringBuilder) {
        if (asHex) {
            stringBuilder.append(BitPatternValue.convertBigIntegerToHexString(new BigInteger(valueString), this.myDataType));
        } else {
            stringBuilder.append(BitPatternValue.convertBigIntegerToDecimalString(new BigInteger(valueString), this.myDataType));
        }
    }

    private void handleRange(boolean asHex, StringBuilder stringBuilder) {
        StringTokenizer tokenizer = new StringTokenizer(this.mySourceStr, "-");
        if (tokenizer.countTokens() == 2) {
            String myValue = tokenizer.nextToken();
            String myEndValue = tokenizer.nextToken();
            this.printValuesAndSeparator(myValue, myEndValue, asHex, "-", stringBuilder);
        }
    }

    private void handleValueMask(boolean asHex, StringBuilder stringBuilder) {
        StringTokenizer tokenizer = new StringTokenizer(this.mySourceStr, ";");
        if (tokenizer.countTokens() == 2) {
            String myValue = tokenizer.nextToken();
            String myMask = tokenizer.nextToken();
            this.printValuesAndSeparator(myValue, myMask, asHex, ";", stringBuilder);
        }
    }

    private void printValuesAndSeparator(String myValue, String myEndValue, boolean asHex, String separator, StringBuilder stringBuilder) {
        this.handleSingleValue(myValue, asHex, stringBuilder);
        stringBuilder.append(separator.equals("-") ? " " + separator + " " : separator);
        this.handleSingleValue(myEndValue, asHex, stringBuilder);
    }

    public String sourceString() {
        return this.mySourceStr;
    }

    public String toString() {
        return this.myListRepresentation;
    }
}

