/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.array.ObjectArrayEditDialog;
import ericsson.vareditor.variable.array.ObjectArrayEditMenu;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import ericsson.vareditor.variable.array.ObjectMapModel;
import ericsson.vareditor.variable.array.table.TableHeaderListener;
import ericsson.vareditor.variable.array.table.TableHeaderSortRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ObjectArrayEditor
extends AbstractPanelVariableEditor
implements ListDataListener {
    static final String DELETE_CONFIRM_MESSAGE = "Are you sure you want to delete this row? \nThis can not be undone.";
    private int hGap = 5;
    private JPanel myButtonPanel = new JPanel();
    private JTable myList;
    private ObjectArrayModel myModel;
    private ObjectArrayEditMenu myPopupMenu;
    private JButton addButton = new JButton("Add");
    private JButton editButton = new JButton("Edit");
    private JButton deleteButton = new JButton("Delete");
    private static final String ADD_ICON_FILE = "new_add.gif";
    private static final String DELETE_ICON_FILE = "new_delete.gif";
    private static final String EDIT_ICON_FILE = "new_edit.gif";
    protected static final int ACTION_ADD = 0;
    protected static final int ACTION_EDIT = 1;
    protected static final int ACTION_DELETE = 2;

    public ObjectArrayEditor(ObjectArrayModel values) {
        this.myModel = values;
        this.myList = new JTable();
        this.myList.setModel(this.myModel);
        this.myList.setName("ObjectArrayEditor.JTable.Rows");
        TableColumnModel columnModel = this.myList.getColumnModel();
        for (int ii = 0; ii < columnModel.getColumnCount(); ++ii) {
            TableColumn valueColumn = this.myList.getColumnModel().getColumn(ii);
            valueColumn.setCellRenderer(this.myModel.getTableCellRenderer(ii));
        }
        this.myList.addMouseListener(new InternalMouseListener());
        this.myList.setSelectionMode(0);
        TableHeaderSortRenderer renderer = new TableHeaderSortRenderer();
        TableHeaderSortRenderer mapKeyRenderer = new TableHeaderSortRenderer();
        mapKeyRenderer.setHorizontalTextPosition(4);
        mapKeyRenderer.setIcon(RmaDefs.getImageIcon("mapkey.png"));
        TableColumnModel model = this.myList.getColumnModel();
        int[] keyColumns = this.myModel instanceof ObjectMapModel ? ((ObjectMapModel)this.myModel).getKeyColumns() : new int[]{};
        Arrays.sort(keyColumns);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            boolean isKeyColumn = Arrays.binarySearch(keyColumns, i) >= 0;
            TableHeaderSortRenderer rend = isKeyColumn ? mapKeyRenderer : renderer;
            model.getColumn(i).setHeaderRenderer(rend);
        }
        this.myList.getTableHeader().addMouseListener(new TableHeaderListener(this.myList.getTableHeader(), renderer));
        this.buildObjectListPanel();
        this.setVisible(true);
    }

    private void buildObjectListPanel() {
        this.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(this.myList);
        pane.setPreferredSize(new Dimension(190, 190));
        this.add((Component)pane, "Center");
        this.createButtonPanel();
        this.add((Component)this.myButtonPanel, "South");
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    private void createButtonPanel() {
        this.addButton.setIcon(RmaDefs.getImageIcon(ADD_ICON_FILE));
        this.editButton.setIcon(RmaDefs.getImageIcon(EDIT_ICON_FILE));
        this.deleteButton.setIcon(RmaDefs.getImageIcon(DELETE_ICON_FILE));
        this.addButton.setName("ObjectArrayEditor.JButton.Add");
        this.editButton.setName("ObjectArrayEditor.JButton.Edit");
        this.deleteButton.setName("ObjectArrayEditor.JButton.Delete");
        this.addButton.setToolTipText("Add a new row");
        this.editButton.setToolTipText("Edit the selected row");
        this.deleteButton.setToolTipText("Delete the selected row");
        this.myButtonPanel.setLayout(new BoxLayout(this.myButtonPanel, 0));
        this.myButtonPanel.add(Box.createHorizontalGlue());
        this.myButtonPanel.add(this.addButton);
        this.myButtonPanel.add(Box.createHorizontalStrut(this.hGap));
        this.myButtonPanel.add(this.editButton);
        this.myButtonPanel.add(Box.createHorizontalStrut(this.hGap));
        this.myButtonPanel.add(this.deleteButton);
        this.myButtonPanel.add(Box.createHorizontalStrut(this.hGap));
        this.myButtonPanel.add(Box.createHorizontalGlue());
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectArrayEditor.this.addButtonActionPerformed(evt);
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectArrayEditor.this.editButtonActionPerformed(evt);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectArrayEditor.this.deleteButtonActionPerformed(evt);
            }
        });
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (this.myModel.getMaxNumberOfRows() > 0 && this.myModel.getRowCount() >= this.myModel.getMaxNumberOfRows()) {
            DialogFactory.getErrorDialog(this, "Limited number of rows", "Max number of rows allowed " + this.myModel.getMaxNumberOfRows());
        } else {
            ObjectArrayEditDialog editDialog = new ObjectArrayEditDialog(this.findOwnerWindow(), this, this.myList, 0);
            editDialog.setTitle(this.myModel.getDialogTitle() + " - Add");
            editDialog.setVisible(true);
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        if (this.myList.getSelectedRow() > -1) {
            ObjectArrayEditDialog editDialog = new ObjectArrayEditDialog(this.findOwnerWindow(), this, this.myList, 1);
            editDialog.setTitle(this.myModel.getDialogTitle() + " - Edit");
            editDialog.setVisible(true);
        }
    }

    private Window findOwnerWindow() {
        return GuiUtil.getClosestWindowParent(this);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int todo;
        if (this.myList.getSelectedRow() != -1 && (todo = JOptionPane.showConfirmDialog(GuiServiceCenter.getInstance().getMainWindow(), DELETE_CONFIRM_MESSAGE)) == 0) {
            this.myModel.removeElementAt(this.myList.getSelectedRow());
            this.myModel.fireTableChanged(new TableModelEvent(this.myModel));
        }
    }

    private void maybeViewPopupMenu(MouseEvent e) {
        if (!(e.getSource() instanceof JTable)) {
            return;
        }
        if (e.isPopupTrigger()) {
            int selRow;
            if (this.myPopupMenu == null) {
                this.myPopupMenu = new ObjectArrayEditMenu(this.findOwnerWindow(), this);
            }
            JTable source = (JTable)e.getSource();
            this.myPopupMenu.setValues(this.myModel, this.myList);
            if (!this.myPopupMenu.isVisible() && (selRow = source.rowAtPoint(new Point(e.getX(), e.getY()))) != -1) {
                source.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
            int row = source.getSelectedRow();
            this.myPopupMenu.enableAction(row, true);
            this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireDataChanged();
    }

    @Override
    public boolean isEditorValueValid() {
        return true;
    }

    public ObjectArrayModel getModel() {
        return this.myModel;
    }

    public void updateSelectedRow(Object[] obj) {
        this.myModel.setValueAt(obj, this.myList.getSelectedRow(), 0);
    }

    public void addNewRow(Object[] obj) {
        int row = this.myList.getSelectedRow();
        if (row < 0) {
            this.myModel.insertRow(this.myList.getRowCount(), obj);
        } else {
            this.myModel.insertRow(row + 1, obj);
        }
        this.myModel.fireTableDataChanged();
    }

    @Override
    public Object getEditorValue() {
        return this.myModel;
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ObjectArrayEditor.this.maybeViewPopupMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ObjectArrayEditor.this.maybeViewPopupMenu(e);
        }
    }
}

