/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array;

import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ObjectArrayDialogPanel
extends JPanel {
    private static final int DEFAULT_INSET = 10;
    private JPanel myEditPanel;
    private JButton myCancelButton;
    private JButton myCloseButton;
    private JButton myOkButton;
    private ObjectArrayFieldView myCreateModifierView;
    private VarTableModel myTableModel;
    private boolean myEditEnabled;
    private String myTitle;

    public ObjectArrayDialogPanel(boolean disableEditing, String title) {
        this.myEditEnabled = !disableEditing;
        this.myTitle = title;
    }

    public void init(VarTableModel model) {
        this.myTableModel = model;
        this.myCreateModifierView = new ObjectArrayFieldView(this.myTableModel);
        this.myCreateModifierView.myVarTableModel.setReadOnly(!this.myEditEnabled);
        this.initComponents();
    }

    public void addOkActionListener(ActionListener aListener) {
        if (this.myOkButton != null) {
            this.myOkButton.addActionListener(aListener);
        }
    }

    public void addCancelActionListener(ActionListener aListener) {
        if (this.myCancelButton != null) {
            this.myCancelButton.addActionListener(aListener);
        }
    }

    public void addCloseActionListener(ActionListener aListener) {
        if (this.myCloseButton != null) {
            this.myCloseButton.addActionListener(aListener);
        }
    }

    private void initComponents() {
        this.myEditPanel = new JPanel();
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        if (!this.myEditEnabled) {
            this.myCloseButton = new JButton("Close");
            this.myCloseButton.setPreferredSize(new Dimension(90, 25));
            con.gridx = 0;
            con.gridy = 0;
            con.anchor = 14;
            con.insets = new Insets(0, 0, 0, 12);
            buttonPanel.add((Component)this.myCloseButton, con);
        } else {
            this.myOkButton = new JButton("OK");
            this.myOkButton.setPreferredSize(new Dimension(90, 25));
            con.gridx = 0;
            con.gridy = 0;
            con.anchor = 17;
            con.insets = new Insets(0, 0, 0, 6);
            buttonPanel.add((Component)this.myOkButton, con);
            this.myCancelButton = new JButton("Cancel");
            this.myCancelButton.setPreferredSize(new Dimension(90, 25));
            con.gridx = 1;
            con.gridy = 0;
            con.anchor = 13;
            con.insets = new Insets(0, 0, 0, 10);
            buttonPanel.add((Component)this.myCancelButton, con);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.myEditPanel.setLayout(new GridBagLayout());
        this.myEditPanel.add((Component)this.myCreateModifierView, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.myEditPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        this.add((Component)buttonPanel, gridBagConstraints);
    }

    class ObjectArrayFieldView
    extends JPanel {
        private VarTableModel myVarTableModel;

        public ObjectArrayFieldView(VarTableModel model) {
            this.myVarTableModel = model;
            this.initComponents();
        }

        private void initComponents() {
            VarTable2 varTable = new VarTable2();
            varTable.setTableModel(this.myVarTableModel);
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder(ObjectArrayDialogPanel.this.myTitle));
            Dimension theTableSize = varTable.getActualPreferredSize();
            Dimension size = new Dimension(350, 230);
            if (theTableSize.height >= size.height) {
                theTableSize.width += 20;
            }
            size.width = Math.max(theTableSize.width, size.width);
            size.width += 20;
            this.add((Component)varTable, "Center");
            size.height = this.getPreferredSize().height;
            this.setPreferredSize(size);
            this.setMinimumSize(size);
        }
    }
}

