/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.datatype.ValueResolverAdapter;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.DataType;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ObjectArrayDataDescription {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private String myLabel;
    private ValueResolver myValueResolver;
    private Object myDefaultValue;
    private boolean useRange = false;
    private boolean useSelection = false;
    private Object[] myChoices;
    private long min;
    private long max;
    private Variable variable = null;
    private TableCellRenderer myTableCellRenderer = null;

    @Deprecated
    public ObjectArrayDataDescription() {
    }

    public ObjectArrayDataDescription(String label, String dataType, Object defaultValue) {
        this(label, new DataTypeBasedResolver(DataType.lookup(dataType), defaultValue));
        this.setDefaultValue(defaultValue);
    }

    public ObjectArrayDataDescription(String label, String dataType, Object defaultValue, long minValue, long maxValue) {
        this(label, new DataTypeBasedResolver(DataType.lookup(dataType), defaultValue), minValue, maxValue);
        this.setDefaultValue(defaultValue);
    }

    public ObjectArrayDataDescription(String label, Integer defaultValue, Object[] choices) {
        this(label, new EnumResolver(defaultValue, choices));
        this.useSelection = true;
        this.myChoices = choices;
    }

    public ObjectArrayDataDescription(String label, ValueResolver valueResolver) {
        if (valueResolver == null) {
            throw new IllegalArgumentException("Null value resolver not permitted.");
        }
        this.myLabel = label;
        this.myValueResolver = valueResolver;
        this.setDefaultValue(valueResolver.createDefaultInstance());
    }

    public ObjectArrayDataDescription(String label, ValueResolver valueResolver, long minValue, long maxValue) {
        this(label, valueResolver);
        this.useRange = true;
        this.min = minValue;
        this.max = maxValue;
    }

    private void setDefaultValue(Object defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.myDefaultValue;
    }

    public String getDataType() {
        DataType dt = this.myValueResolver.getDataType();
        return dt != null ? dt.getTypeName() : "";
    }

    public String getLabel() {
        return this.myLabel;
    }

    public Variable createVariable(Object value) {
        Variable var;
        if (this.variable != null) {
            var = this.variable;
            var.setValue(value);
        } else if (this.useSelection) {
            var = new DropDownVariable(this.myLabel, (int)((Integer)value), this.myChoices);
        } else {
            DataType dt = this.getValueDataType(value);
            var = this.getVariable(this.myLabel, dt, value);
            if (this.useRange && dt.isIntegerNumeric() && var instanceof StringVariable) {
                ((StringVariable)var).setModel(new NumbersOnlyDocument(this.min, this.max, false));
            }
        }
        return var;
    }

    protected DataType getValueDataType(Object o) {
        return this.myValueResolver.getDataType();
    }

    public void setVariable(Variable var) {
        this.variable = var;
    }

    protected Variable getVariable(String label, DataType dataType, Object value) {
        return VariableFactory.getVariableOfDataType(dataType.getTypeName(), label, null, null, null, value);
    }

    public TableCellRenderer getTableCellRenderer() {
        if (this.myTableCellRenderer == null) {
            this.myTableCellRenderer = this.createTableCellRenderer();
        }
        return this.myTableCellRenderer;
    }

    protected TableCellRenderer createTableCellRenderer() {
        ValueResolver resolver = this.getValueResolver();
        return new ObjectArrayDefaultTableCellRenderer(resolver);
    }

    public void setTableCellRenderer(TableCellRenderer cellRenderer) {
        this.myTableCellRenderer = cellRenderer;
    }

    protected ValueResolver createValueResolver() {
        return this.myValueResolver;
    }

    public ValueResolver getValueResolver() {
        ValueResolver r = this.myValueResolver;
        if (this.myChoices == null && (r = this.createValueResolver()) != this.myValueResolver) {
            this.myValueResolver = r;
        }
        return r;
    }

    public String toXmlAttributeValue(Object value) {
        String ret = this.isObjectType() || value instanceof ERETime && !EREDateUtil.isBoundaryDate(value) ? this.getValueResolver().makeValueString(value) : (value instanceof Date ? DATE_FORMAT.format(value) : (value instanceof EREDate && !EREDateUtil.isBoundaryDate(value) ? this.toXmlAttributeValue(((EREDate)value).asDate()) : (value instanceof RatingDecimal ? ((RatingDecimal)value).toDotString(6, 4) : value.toString())));
        return ret;
    }

    private boolean isObjectType() {
        ValueResolver r = this.getValueResolver();
        DataType dt = r.getDataType();
        return dt == null || dt == DataType.OBJECT;
    }

    public Object convertValueFromXml(Object value) {
        return value;
    }

    public FieldHierarchyNode.ComplexType getCollectionType() {
        return FieldHierarchyNode.ComplexType.NONE;
    }

    public static String getDataTypeStringForObject(Object object) {
        String classStr = object.getClass().getSimpleName();
        if (classStr.endsWith("[]")) {
            classStr = classStr.substring(0, classStr.length() - 2);
        }
        return classStr;
    }

    public static Object getDefaultValueForDataType(String dataType) {
        DataType dt = DataType.lookup(dataType);
        if (dt != null) {
            return dt.createDefaultInstance();
        }
        return null;
    }

    public Object[] createDefaultArray(int size) {
        ValueResolver res = this.getValueResolver();
        Class clazz = res.getDataType() == DataType.DATE ? EREDate.class : (res.getDataType() == DataType.TIME ? ERETime.class : res.createDefaultInstance().getClass());
        return (Object[])Array.newInstance(clazz, size);
    }

    public static Object[] createDefaultArray(String dataType, int size) {
        DataType dt = DataType.lookup(dataType);
        if (dt != null) {
            return dt.createArray(size);
        }
        return null;
    }

    private static class DataTypeBasedResolver
    extends ValueResolverAdapter {
        private Object myDefault;

        DataTypeBasedResolver(DataType dt, Object defaultValue) {
            super(dt);
            Object def = defaultValue;
            if (dt != DataType.STRING && defaultValue instanceof String && (def = dt.parseValue((String)defaultValue)) == null) {
                def = dt.createDefaultInstance();
            }
            this.myDefault = def;
        }

        @Override
        public Object createDefaultInstance() {
            return this.myDefault;
        }

        @Override
        public String makeDisplayString(Object anObject) {
            DataType dt = this.getDataType();
            return dt != null ? super.makeDisplayString(anObject) : this.createString(anObject);
        }

        private String createString(Object anObject) {
            return anObject == null ? "" : anObject.toString();
        }
    }

    private static class EnumResolver
    extends ValueResolverAdapter {
        private Integer myDefault;
        private Object[] myResolverChoices;

        EnumResolver(Integer defaultValue, Object[] choices) {
            super(DataType.INTEGER);
            this.myDefault = defaultValue;
            this.myResolverChoices = choices;
        }

        @Override
        public DataType getDataType() {
            return DataType.STRING;
        }

        @Override
        public Object createDefaultInstance() {
            return this.myDefault;
        }

        @Override
        public String makeDisplayString(Object anObject) {
            Integer idx = (Integer)anObject;
            return String.valueOf(this.myResolverChoices[idx]);
        }
    }

    class ObjectArrayDefaultTableCellRenderer
    extends DefaultTableCellRenderer {
        private ValueResolver myResolver;

        ObjectArrayDefaultTableCellRenderer(ValueResolver resolver) {
            this.myResolver = resolver;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            try {
                text = this.makeDisplayStringWithResolver(value, this.myResolver);
            }
            catch (IllegalArgumentException iae) {
                DataType theResolver = DataType.fromObjectClass(value);
                text = this.makeDisplayStringWithResolver(value, theResolver);
            }
            Component comp = super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel && this.shouldRightAlignText()) {
                ((JLabel)comp).setHorizontalAlignment(4);
            }
            return comp;
        }

        private String makeDisplayStringWithResolver(Object value, ValueResolver resolver) {
            String text = resolver == null ? (value == null ? "" : value.toString()) : resolver.makeDisplayString(value);
            return text;
        }

        private boolean shouldRightAlignText() {
            DataType dt;
            boolean align = false;
            if (this.myResolver != null && (dt = this.myResolver.getDataType()) != null) {
                align = dt.isNumeric() || dt == DataType.AMOUNT || dt == DataType.MONETARYUNITS;
            }
            return align;
        }
    }
}

