/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.swing.IconIndicableTextField;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.IconIndication;
import ericsson.vareditor.variable.IconIndicationType;
import ericsson.vareditor.variable.StringVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class WatermarkStringVariable
extends StringVariable
implements IconIndication {
    private String myWatermarkString;
    private Icon myIndicationIcon = null;
    private boolean myDisableValueChanged = false;
    private boolean myHasReceivedInput = false;

    public WatermarkStringVariable(String label, Document document, String watermarkString, IconIndicationType indicationType) {
        super(label);
        this.myWatermarkString = watermarkString;
        this.myModel = document;
        this.myValue = watermarkString;
        this.myIndicationIcon = indicationType.getIconForType();
    }

    public WatermarkStringVariable(String label, String value, Document document, String watermarkString, IconIndicationType indicationType) {
        super(label);
        this.myWatermarkString = watermarkString;
        this.myModel = document;
        this.myIndicationIcon = indicationType.getIconForType();
        this.assignValue(value);
        this.setEditorValue(this.myValue);
    }

    public WatermarkStringVariable(String label, Document document, String watermarkString, String iconName) {
        super(label);
        this.myWatermarkString = watermarkString;
        this.myModel = document;
        this.myValue = watermarkString;
        this.myIndicationIcon = RmaDefs.getImageIcon(iconName);
    }

    public WatermarkStringVariable(String label, String value, Document document, String watermarkString, String iconName) {
        super(label);
        this.myWatermarkString = watermarkString;
        this.myModel = document;
        this.myIndicationIcon = RmaDefs.getImageIcon(iconName);
        this.assignValue(value);
        this.setEditorValue(this.myValue);
    }

    protected WatermarkStringVariable(WatermarkStringVariable original) {
        super(original.getLabel());
        this.setKey(original.getKey());
        this.myWatermarkString = original.myWatermarkString;
        this.myModel = original.myModel;
        this.myValue = original.myValue;
        this.myIndicationIcon = original.myIndicationIcon;
    }

    @Override
    public Object clone() {
        return new WatermarkStringVariable(this);
    }

    private void assignValue(String value) {
        this.myValue = value == null ? this.myWatermarkString : value;
    }

    @Override
    public Component getEditor() {
        JTextComponent component = (JTextComponent)super.getEditor();
        this.updateTextColor();
        return component;
    }

    @Override
    protected JTextComponent createEditor() {
        IconIndicableTextField component = new IconIndicableTextField();
        component.setIcon(this.myIndicationIcon);
        component.setName("InputTextField");
        return component;
    }

    @Override
    public Object getValueObject() {
        return this.getValueString();
    }

    @Override
    public String getValueString() {
        String returnValue = this.valueIsEmpty() ? null : this.myValue;
        return returnValue;
    }

    public String getWatermarkString() {
        return this.myWatermarkString;
    }

    private void updateTextColor() {
        if (this.valueIsEmpty()) {
            this.myEditor.setForeground(Color.GRAY);
        } else {
            this.myEditor.setForeground(Color.BLACK);
        }
    }

    private boolean valueIsEmpty() {
        return this.myValue == null || this.myValue.equals(this.myWatermarkString) || this.myValue.equals("");
    }

    @Override
    public void focusGained(FocusEvent e) {
        JTextField editor = (JTextField)this.getEditor();
        if (editor.getText().equals(this.myWatermarkString) && !this.myHasReceivedInput) {
            this.setTextWithNotificationDisable(editor, "");
            editor.setForeground(Color.BLACK);
        }
        this.myHasReceivedInput = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        JTextField editor = (JTextField)this.getEditor();
        if (editor.getText().equals("")) {
            this.setTextWithNotificationDisable(editor, this.myWatermarkString);
            editor.setForeground(Color.GRAY);
        }
        this.myHasReceivedInput = false;
    }

    private void setTextWithNotificationDisable(JTextField editor, String text) {
        try {
            this.myDisableValueChanged = true;
            editor.setText(text);
        }
        finally {
            this.myDisableValueChanged = false;
        }
    }

    @Override
    public List<Icon> getIconsToUse() {
        return Collections.singletonList(this.myIndicationIcon);
    }

    @Override
    public boolean getIndicationStateFor(Icon icon) {
        return ((IconIndicableTextField)this.getEditor()).isShowingIndication();
    }

    @Override
    public void setIndicationState(boolean state, Icon icon) {
        ((IconIndicableTextField)this.getEditor()).toggleIndication(state);
    }

    @Override
    protected void fireValueChanged() {
        if (!this.myDisableValueChanged) {
            this.myHasReceivedInput = true;
            super.fireValueChanged();
        }
    }
}

