/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class VarListUtil {
    public static String getStringValueForName(List<Variable> variables, String varname) {
        return (String)VarListUtil.getObjectForName(variables, varname);
    }

    public static Integer getIntValueForName(List<Variable> variables, String varname) {
        return (Integer)VarListUtil.getObjectForName(variables, varname);
    }

    public static Long getLongValueForName(List<Variable> variables, String varname) {
        return (Long)VarListUtil.getObjectForName(variables, varname);
    }

    public static Short getShortValueForName(List<Variable> variables, String varname) {
        return (Short)VarListUtil.getObjectForName(variables, varname);
    }

    public static Boolean getBooleanValueForName(List<Variable> variables, String varname) {
        return (Boolean)VarListUtil.getObjectForName(variables, varname);
    }

    public static Double getDoubleValueForName(List<Variable> variables, String varname) {
        return (Double)VarListUtil.getObjectForName(variables, varname);
    }

    public static Object getValueForName(List<Variable> variables, String varname) {
        return VarListUtil.getObjectForName(variables, varname);
    }

    public static Object getTimeValueForName(List<Variable> variables, String varname) {
        return VarListUtil.getObjectForName(variables, varname);
    }

    public static String getValueStringForName(List<Variable> variables, String varname) {
        if (varname == null) {
            return null;
        }
        for (Variable v : variables) {
            if (!varname.equals(v.getLabel())) continue;
            return v.getValueString();
        }
        return null;
    }

    public static String getValueStringForKey(List<Variable> variables, String key) {
        if (key == null) {
            return null;
        }
        for (Variable v : variables) {
            if (!key.equals(v.getKey())) continue;
            return v.getValueString();
        }
        return null;
    }

    private static Object getObjectForName(List<Variable> variables, String varname) {
        if (varname == null) {
            return null;
        }
        for (Variable v : variables) {
            if (!varname.equals(v.getLabel())) continue;
            return v.getValueObject();
        }
        return null;
    }

    public static Variable getVariableForName(List<Variable> variables, String varname) {
        if (varname == null) {
            return null;
        }
        for (Variable v : variables) {
            if (!varname.equals(v.getLabel())) continue;
            return v;
        }
        return null;
    }

    public static Variable getVariableForKey(List<Variable> variables, String key) {
        if (key == null || variables == null) {
            return null;
        }
        for (Variable v : variables) {
            if (!key.equals(v.getKey())) continue;
            return v;
        }
        return null;
    }

    public static boolean equalsVariableList(List<?> vars1, List<?> vars2) {
        boolean dirtyVars = false;
        if (vars1 == null || vars2 == null) {
            return false;
        }
        if (vars1.size() != vars2.size()) {
            return false;
        }
        for (int i = 0; i < vars1.size(); ++i) {
            if (vars1.get(i).toString().equals(vars2.get(i).toString())) continue;
            dirtyVars = true;
        }
        return !dirtyVars;
    }

    public static List<Variable> cloneVariableList(List<Variable> vars) {
        if (vars == null) {
            return null;
        }
        ArrayList<Variable> newList = new ArrayList<Variable>(vars.size());
        for (int i = 0; i < vars.size(); ++i) {
            newList.add(i, (BaseVariable)vars.get(i).clone());
        }
        return newList;
    }

    public static boolean removeVariablesByLabel(List<Variable> varList, String ... labels) {
        return VarListUtil.removeVariablesByLabel(varList, null, labels);
    }

    public static boolean removeVariablesByLabel(List<Variable> varList, Map<String, ?> map, String ... labels) {
        boolean removed = false;
        block0: for (int i = varList.size() - 1; i >= 0; --i) {
            for (String label : labels) {
                if (!varList.get(i).getLabel().equals(label)) continue;
                varList.remove(i);
                if (map != null && map.containsKey(label)) {
                    map.remove(label);
                }
                removed = true;
                continue block0;
            }
        }
        return removed;
    }

    public static boolean insertVariableAfterLabel(List<Variable> varList, String label, Variable ... newVars) {
        for (int i = 0; i < varList.size(); ++i) {
            if (!varList.get(i).getLabel().equals(label)) continue;
            for (int j = 0; j < newVars.length; ++j) {
                varList.add(i + j + 1, newVars[j]);
            }
            return true;
        }
        return false;
    }

    public static boolean insertVariableAfterKey(List<Variable> varList, String key, Variable ... newVars) {
        for (int i = 0; i < varList.size(); ++i) {
            if (!varList.get(i).getKey().equals(key)) continue;
            for (int j = 0; j < newVars.length; ++j) {
                varList.add(i + j + 1, newVars[j]);
            }
            return true;
        }
        return false;
    }

    public static boolean retainVariablesByLabel(List<Variable> varList, String ... labels) {
        boolean removed = false;
        List<String> labelList = Arrays.asList(labels);
        for (int i = varList.size() - 1; i >= 0; --i) {
            String lbl = varList.get(i).getLabel();
            if (labelList.contains(lbl)) continue;
            varList.remove(i);
            removed = true;
        }
        return removed;
    }

    public static boolean retainVariablesByKey(List<Variable> varList, String ... keys) {
        boolean removed = false;
        List<String> keyList = Arrays.asList(keys);
        for (int i = varList.size() - 1; i >= 0; --i) {
            String key = varList.get(i).getKey();
            if (keyList.contains(key)) continue;
            varList.remove(i);
            removed = true;
        }
        return removed;
    }

    public static boolean areAllValid(List<Variable> vars) {
        boolean valid = true;
        for (Variable var : vars) {
            if (var.isValueValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static boolean replaceVariableByLabel(List<Variable> vars, String label, Variable replacement) {
        boolean replaced = false;
        for (int i = 0; i < vars.size(); ++i) {
            Variable var = vars.get(i);
            if (!var.getLabel().equals(label)) continue;
            vars.set(i, replacement);
            replaced = true;
            break;
        }
        return replaced;
    }

    public static boolean replaceVariableByKey(List<Variable> vars, String key, Variable replacement) {
        boolean replaced = false;
        for (int i = 0; i < vars.size(); ++i) {
            Variable var = vars.get(i);
            if (!var.getKey().equals(key)) continue;
            vars.set(i, replacement);
            replaced = true;
            break;
        }
        return replaced;
    }

    public static boolean removeVariablesByKey(List<Variable> varList, String ... keys) {
        boolean removed = false;
        block0: for (int i = varList.size() - 1; i >= 0; --i) {
            for (String key : keys) {
                if (!varList.get(i).getKey().equals(key)) continue;
                varList.remove(i);
                removed = true;
                continue block0;
            }
        }
        return removed;
    }
}

