/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.vareditor.variable.AmountVariable;
import ericsson.vareditor.variable.FieldUser;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.ValueFieldPanel;
import ericsson.vareditor.variable.Variable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;

public class ValueFieldVariable
extends PanelVariable
implements FieldUser {
    protected String[] myAvailableFields;
    protected ValueType[] myValueTypes;
    protected ValueType mySelectedType;
    protected Map<String, FieldDefinition> myFieldMap;
    protected AvailableFieldListBuilder myBuilder;

    protected ValueFieldVariable(String label, ValueFieldCompositeObject obj, String[] availableFields, ValueType type) {
        super(label, obj);
        this.myAvailableFields = availableFields != null ? Arrays.copyOf(availableFields, availableFields.length) : null;
        this.myValueTypes = new ValueType[]{type};
        this.myFieldMap = null;
    }

    public ValueFieldVariable(String label, ValueFieldCompositeObject obj, String[] availableFields, Document doc) {
        this(label, obj, availableFields, new ValueType(doc, null));
    }

    public ValueFieldVariable(String label, ValueFieldCompositeObject obj, Map<String, FieldDefinition> fieldMap, Document doc, DataType dataType) {
        this(label, obj, null, new ValueType(doc, dataType));
        if (fieldMap == null) {
            throw new IllegalArgumentException("fieldMap cannot be null");
        }
        this.myFieldMap = fieldMap;
    }

    public ValueFieldVariable(String label, ValueFieldCompositeObject obj, String[] availableFields, Document doc, DataType dataType) {
        this(label, obj, availableFields, new ValueType(doc, dataType));
    }

    public ValueFieldVariable(String label, ValueFieldCompositeObject obj, String[] availableFields, DataType dataType) {
        this(label, obj, availableFields, new ValueType(null, dataType));
    }

    protected ValueFieldVariable(String label, ValueFieldCompositeObject obj, String[] availableFields, ValueType[] types, ValueType selected) {
        this(label, obj, availableFields, (Document)null);
        this.myValueTypes = Arrays.copyOf(types, types.length);
        this.mySelectedType = selected;
    }

    private ValueFieldVariable(String label, ValueFieldCompositeObject obj, ValueType[] types, ValueType selected, Map<String, FieldDefinition> fieldMap) {
        this(label, obj, null, types, selected);
        if (fieldMap == null) {
            throw new IllegalArgumentException("fieldMap cannot be null");
        }
        this.myFieldMap = fieldMap;
    }

    private ValueFieldVariable(String label, ValueFieldCompositeObject obj, ValueType[] types, ValueType selected, AvailableFieldListBuilder builder) {
        this(label, obj, null, types, selected);
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.myBuilder = builder;
    }

    public static ValueFieldVariable createForMultipleTypes(String label, ValueFieldCompositeObject obj, String[] availableFields, ValueType[] types) {
        return new ValueFieldVariable(label, obj, availableFields, types, types[0]);
    }

    public static ValueFieldVariable createForMultipleTypes(String label, ValueFieldCompositeObject obj, ValueType[] types, Map<String, FieldDefinition> fieldMap) {
        return new ValueFieldVariable(label, obj, types, types[0], fieldMap);
    }

    public static ValueFieldVariable createForMultipleTypes(String label, ValueFieldCompositeObject obj, ValueType[] types, AvailableFieldListBuilder builder) {
        return new ValueFieldVariable(label, obj, types, types[0], builder);
    }

    public static ValueFieldVariable createForMultipleTypesWithSelected(String label, ValueFieldCompositeObject obj, String[] availableFields, ValueType[] types, ValueType selected) {
        return new ValueFieldVariable(label, obj, availableFields, types, selected);
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        if (this.myPanelVariableEditor == null) {
            this.myPanelVariableEditor = this.myBuilder != null ? new ValueFieldPanel((ValueFieldCompositeObject)this.myValue, this.myValueTypes, this.mySelectedType, this.myBuilder) : (this.myFieldMap != null ? new ValueFieldPanel((ValueFieldCompositeObject)this.myValue, this.myValueTypes, this.mySelectedType, this.myFieldMap) : new ValueFieldPanel((ValueFieldCompositeObject)this.myValue, this.myValueTypes, this.mySelectedType, this.myAvailableFields));
            this.myPanelVariableEditor.setEditorListener(this);
        }
        return this.myPanelVariableEditor;
    }

    @Override
    public Object getValueObject() {
        return this.myValue;
    }

    @Override
    public String getValueString() {
        return ((ValueFieldCompositeObject)this.myValue).getFieldOrValueAsString();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("Clone not implemented.");
    }

    @Override
    protected void setEditorValue() {
        if (this.myPanelVariableEditor != null) {
            ((ValueFieldPanel)this.myPanelVariableEditor).setEditorValue((ValueFieldCompositeObject)this.myValue);
        }
    }

    @Override
    protected void validate() {
        this.myIsValid = ((ValueFieldPanel)this.getPanelVariableEditor()).isEditorValueValid();
    }

    @Override
    protected void setVarValue(Object v) {
        if (!(v instanceof ValueFieldCompositeObject)) {
            throw new IllegalArgumentException("Unknown object");
        }
        this.myValue = v;
        this.setEditorValue();
    }

    @Override
    protected void setVarValue(String v) {
        throw new UnsupportedOperationException();
    }

    public boolean inFieldMode() {
        return ((ValueFieldPanel)this.createPanelVariableEditor()).inUseFieldMode();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isAllowEdit() && this.myPanelVariableEditor != null) {
            ValueFieldPanel panel = (ValueFieldPanel)this.myPanelVariableEditor;
            panel.setEnabled(enabled);
        }
    }

    @Override
    public List<String> getReservedFields() {
        if (this.inFieldMode()) {
            return Collections.singletonList(this.getValueString());
        }
        return Collections.emptyList();
    }

    public static class AmountValueType
    extends ValueType {
        private ClassRepository myRepository;
        private boolean myAllowNegative;

        @Deprecated
        public AmountValueType(ClassRepository repository, String field) {
            this(repository, false);
        }

        public AmountValueType(ClassRepository repository, boolean allowNegativeValue) {
            super(null, DataType.AMOUNT, "Amount");
            this.myRepository = repository;
            this.myAllowNegative = allowNegativeValue;
        }

        @Override
        public AmountVariable createVariable(String label, String value) {
            return VariableFactory.createAmountVariable(label, null, this.myRepository, value, this.myAllowNegative);
        }
    }

    public static class ValueType {
        private Document myDocument;
        private DataType myDataType;
        private String myDesc;

        public ValueType(Document doc, DataType dt) {
            this.myDocument = doc;
            this.myDataType = dt;
        }

        public boolean hasValueClassFactory() {
            return false;
        }

        public ValueType(Document doc, DataType dt, String description) {
            this(doc, dt);
            this.myDesc = description;
        }

        public DataType getDataType() {
            return this.myDataType;
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public String getDescription() {
            return this.myDesc;
        }

        public Variable createVariable(String label, String value) {
            return null;
        }
    }
}

