/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.UnsignedInt8;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class UnsignedInt8Variable
extends AbstractNumberStringVariable {
    protected int myMinValue;
    protected int myMaxValue;

    public UnsignedInt8Variable(String label, UnsignedInt8 value) {
        super(label);
        this.myValue = value.toString();
        this.setMinMax(0, 255);
    }

    public UnsignedInt8Variable(String label, String value) {
        super(label, value);
        this.setMinMax(0, 255);
    }

    public UnsignedInt8Variable(String label, UnsignedInt8 value, int min, int max) {
        super(label);
        this.myValue = value.toString();
        this.setMinMax(min, max);
    }

    public UnsignedInt8Variable(String label, String value, int min, int max) {
        super(label, value);
        this.setMinMax(min, max);
    }

    public UnsignedInt8Variable(UnsignedInt8Variable v) {
        super(v);
        this.myValue = v.myValue;
        this.setMinMax(v.myMinValue, v.myMaxValue);
    }

    private void setMinMax(int min, int max) {
        this.myMinValue = min < 0 ? 0 : min;
        this.myMaxValue = max < 0 ? 0 : max;
    }

    @Override
    public Object clone() {
        return new UnsignedInt8Variable(this);
    }

    @Override
    protected String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(value)) {
            return UnsignedInt8.valueOf(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "UnsignedInt8";
    }

    public Class<UnsignedInt8> getValueClass() {
        return UnsignedInt8.class;
    }

    @Override
    public int getFormat() {
        return 2002;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new NumbersOnlyDocument(this.myMinValue, this.myMaxValue);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

