/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.log.logtable.NumberListTableModel;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.TableVariable;
import ericsson.vareditor.variable.TableVariableCellEditor;
import ericsson.vareditor.variable.TableVariableException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class TableVariablePanel
extends AbstractPanelVariableEditor
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTable myTable;
    private JTable myTableFrame;
    private JDialog myEditDialog;
    private TableVariable myVariable;
    private JPanel mySearchPanel;
    private JPanel mySearchPanelFrame;
    private NumberListTableModel myModel;
    private JButton myEditButton = new JButton("...");

    public TableVariablePanel(NumberListTableModel model, TableVariable var) {
        super(new GridBagLayout());
        this.myModel = model;
        this.myVariable = var;
        this.add((Component)this.createPanel(false), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel createPanel(boolean isDialog) {
        JScrollPane scrollPane;
        JPanel panel = new JPanel(new GridBagLayout());
        JTextField inputField = new JTextField();
        inputField.setPreferredSize(new Dimension(20, 24));
        inputField.setDocument(this.myModel.getValidator().getDocument());
        JButton addButton = new JButton();
        addButton.setIcon(RmaDefs.getImageIcon("new_add.gif"));
        addButton.setPreferredSize(new Dimension(23, 23));
        addButton.setToolTipText("Add a new entry (Enter)");
        JButton deleteButton = new JButton();
        deleteButton.setIcon(RmaDefs.getImageIcon("new_delete.gif"));
        deleteButton.setPreferredSize(new Dimension(23, 23));
        deleteButton.setToolTipText("Delete the selected entry/entries (Delete)");
        JButton searchButton = new JButton();
        searchButton.setIcon(RmaDefs.getImageIcon("new_view.gif"));
        searchButton.setPreferredSize(new Dimension(23, 23));
        searchButton.setToolTipText("Search for entry (F3)");
        JPanel newPanel = new JPanel(new GridBagLayout());
        newPanel.add((Component)inputField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 0, 0, 0), 0, 0));
        newPanel.add((Component)addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 2, 1, 0), 0, 0));
        newPanel.add((Component)deleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 2, 1, 0), 0, 0));
        newPanel.add((Component)searchButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 2, 1, 2), 0, 0));
        JTable table = new JTable(this.myModel);
        table.getColumnModel().getColumn(0).setHeaderValue(null);
        table.getTableHeader().setVisible(false);
        table.setBackground(Color.WHITE);
        table.setBorder(null);
        table.getColumnModel().getColumn(0).setCellEditor(new TableVariableCellEditor(this.myModel));
        table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        JPanel searchPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("SearchMode");
        label.setFont(new Font("Arial", 0, 12));
        JButton cancelSearchButton = new JButton();
        cancelSearchButton.setIcon(RmaDefs.getImageIcon("delete2_13.png"));
        cancelSearchButton.setPreferredSize(new Dimension(16, 16));
        cancelSearchButton.setToolTipText("Exit search (Esc)");
        searchPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        searchPanel.add((Component)cancelSearchButton, new GridBagConstraints(1, 0, 0, 0, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        searchPanel.setVisible(false);
        if (isDialog) {
            this.mySearchPanelFrame = searchPanel;
            if (this.mySearchPanel.isVisible()) {
                this.mySearchPanelFrame.setVisible(true);
            }
            this.myTableFrame = table;
            scrollPane = new JScrollPane(this.myTableFrame, 22, 30);
            scrollPane.setPreferredSize(new Dimension(10, 10));
        } else {
            this.mySearchPanel = searchPanel;
            this.myTable = table;
            scrollPane = new JScrollPane(this.myTable, 22, 32);
            scrollPane.setPreferredSize(new Dimension(10, 125));
            this.myEditButton.setBorderPainted(false);
            this.myEditButton.setToolTipText("Edit Numbers");
            this.myEditButton.addActionListener(this);
            scrollPane.setCorner("LOWER_RIGHT_CORNER", this.myEditButton);
            panel.setBorder(null);
        }
        panel.add((Component)newPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (isDialog) {
            panel.add((Component)this.mySearchPanelFrame, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
        } else {
            panel.add((Component)this.mySearchPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
        }
        panel.add((Component)scrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        new ActionHandler(inputField, table, addButton, deleteButton, searchButton, cancelSearchButton);
        return panel;
    }

    @Override
    public Object getEditorValue() {
        return this.myModel;
    }

    @Override
    public boolean isEditorValueValid() {
        return true;
    }

    private void scrollToCell(int startInterval, int stopInterval) {
        Rectangle rect = this.myTable.getCellRect(startInterval, stopInterval, true);
        this.myTable.scrollRectToVisible(rect);
        this.myTable.setRowSelectionInterval(startInterval, stopInterval);
        if (this.myTableFrame != null) {
            this.myTableFrame.scrollRectToVisible(rect);
            this.myTableFrame.setRowSelectionInterval(startInterval, stopInterval);
        }
    }

    private void searchAndDisplayValueInModel(String searchString) {
        this.myModel.setSearchFilter(searchString);
    }

    private void handlePasteAction() {
        String pasteStr = "";
        int countPaste = 0;
        ArrayList<String> invalidEntries = new ArrayList<String>();
        ArrayList<String> validEntries = new ArrayList<String>();
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipData = clip.getContents(clip);
        try {
            pasteStr = (String)clipData.getTransferData(DataFlavor.stringFlavor);
            String[] pasteStrArray = pasteStr.split("[\t\r\n,:; ]");
            for (int i = 0; i < pasteStrArray.length; ++i) {
                if (pasteStrArray[i].equals("")) continue;
                try {
                    if (this.myModel.getValidator().isInputValid(pasteStrArray[i]) && this.myModel.getValidator().isInputValidWithInfo(pasteStrArray[i])) {
                        validEntries.add(pasteStrArray[i]);
                    } else {
                        invalidEntries.add("Not a valid input (" + pasteStrArray[i] + ").");
                    }
                }
                catch (TableVariableException e) {
                    invalidEntries.add(e.getMessage());
                }
                ++countPaste;
            }
            String[] entriesInModel = this.myModel.getValueString().split(",");
            boolean neverAskAgain = false;
            for (int i = 0; i < validEntries.size(); ++i) {
                ArrayList<String> entriesInModelMatchingInput = new ArrayList<String>();
                boolean inputHasSmallerSize = false;
                for (int k = 0; k < entriesInModel.length; ++k) {
                    if (!this.myModel.getValidator().isValueInModel((String)validEntries.get(i), entriesInModel[k])) continue;
                    inputHasSmallerSize = ((String)validEntries.get(i)).length() < entriesInModel[k].length();
                    entriesInModelMatchingInput.add(entriesInModel[k]);
                }
                if (entriesInModelMatchingInput.size() > 0 && inputHasSmallerSize) {
                    String askUserString = "Your entry (" + (String)validEntries.get(i) + ") is already in the model ";
                    for (int k = 0; k < entriesInModelMatchingInput.size(); ++k) {
                        if (k != 0) {
                            askUserString = askUserString + ",";
                        }
                        askUserString = askUserString + "(" + (String)entriesInModelMatchingInput.get(k) + ")";
                    }
                    askUserString = entriesInModelMatchingInput.size() > 1 ? askUserString + ".\n\nReplace all old entries with your new entry (" + (String)validEntries.get(i) + ")?" : askUserString + ".\n\nReplace (" + (String)entriesInModelMatchingInput.get(0) + ") with your new entry (" + (String)validEntries.get(i) + ")?";
                    if (!neverAskAgain) {
                        Object[] options = new Object[]{"Replace", "Skip", "Skip all"};
                        int answer = JOptionPane.showOptionDialog(this, askUserString, "Value already in model", 0, 0, null, options, options[1]);
                        if (answer == 0) {
                            for (int k = 0; k < entriesInModelMatchingInput.size(); ++k) {
                                this.myModel.clearEntry(entriesInModelMatchingInput.get(k));
                            }
                            this.addEntry((String)validEntries.get(i));
                            entriesInModel = this.myModel.getValueString().split(",");
                            continue;
                        }
                        if (answer == 2) {
                            neverAskAgain = true;
                        }
                        String infoToUser = "Entry (" + (String)validEntries.get(i) + ") is already in the model ";
                        for (int k = 0; k < entriesInModelMatchingInput.size(); ++k) {
                            if (k != 0) {
                                infoToUser = infoToUser + ",";
                            }
                            infoToUser = infoToUser + "(" + (String)entriesInModelMatchingInput.get(k) + ")";
                        }
                        infoToUser = infoToUser + ".";
                        invalidEntries.add(infoToUser);
                        continue;
                    }
                    String infoToUser = "Entry (" + (String)validEntries.get(i) + ") is already in the model ";
                    for (int k = 0; k < entriesInModelMatchingInput.size(); ++k) {
                        if (k != 0) {
                            infoToUser = infoToUser + ",";
                        }
                        infoToUser = infoToUser + "(" + (String)entriesInModelMatchingInput.get(k) + ")";
                    }
                    infoToUser = infoToUser + ".";
                    invalidEntries.add(infoToUser);
                    continue;
                }
                if (entriesInModelMatchingInput.size() > 0 && !inputHasSmallerSize) {
                    String infoToUser = "Entry (" + (String)validEntries.get(i) + ") is already in the model ";
                    for (int k = 0; k < entriesInModelMatchingInput.size(); ++k) {
                        if (k != 0) {
                            infoToUser = infoToUser + ",";
                        }
                        infoToUser = infoToUser + "(" + (String)entriesInModelMatchingInput.get(k) + ")";
                    }
                    infoToUser = infoToUser + ".";
                    invalidEntries.add(infoToUser);
                    continue;
                }
                this.myModel.add((String)validEntries.get(i));
                entriesInModel = this.myModel.getValueString().split(",");
            }
            String infoNotValid = "Total entries: " + countPaste + "\nCould not paste the following " + invalidEntries.size() + " entries:\n\n";
            for (int i = 0; i < invalidEntries.size(); ++i) {
                infoNotValid = infoNotValid + (i + 1) + ". " + (String)invalidEntries.get(i) + "\n";
                if (i < 9) continue;
                infoNotValid = infoNotValid + "...\n";
                break;
            }
            infoNotValid = infoNotValid + "\n";
            if (invalidEntries.size() > 0) {
                JOptionPane.showMessageDialog(this, infoNotValid, "Warning", 2);
            } else {
                JOptionPane.showMessageDialog(this, "Successfully imported entries!", "Confirm", 1);
            }
        }
        catch (IOException ufe) {
            ExceptionUtil.handleException(ufe, "navigator", 1, "Could not handle your input", false);
        }
        catch (UnsupportedFlavorException ex) {
            ExceptionUtil.handleException(ex, "navigator", 1, "Could not handle your input", false);
        }
    }

    private void addEntry(String input) {
        try {
            if (this.myModel.getValidator().isInputValid(input) && !this.myModel.getValidator().isValueInModelWithInfo(input, this.myModel.getValueString())) {
                this.myModel.add(input);
                this.scrollToCell(this.myModel.getRowCount() - 1, this.myModel.getRowCount() - 1);
            }
        }
        catch (TableVariableException e) {
            String[] entriesInModel = this.myModel.getValueString().split(",");
            int valuesInModel = entriesInModel.length;
            ArrayList<String> matchingEntries = new ArrayList<String>();
            for (int i = 0; i < valuesInModel; ++i) {
                if (!this.myModel.getValidator().isValueInModel(input, entriesInModel[i])) continue;
                matchingEntries.add(entriesInModel[i]);
            }
            String outputMessage = "The value (" + input + ") is already in the model ";
            int countOfHits = 0;
            for (int i = 0; i < matchingEntries.size(); ++i) {
                if (input.length() >= ((String)matchingEntries.get(i)).length()) continue;
                if (i != 0) {
                    outputMessage = outputMessage + ", ";
                }
                ++countOfHits;
                outputMessage = outputMessage + "(" + (String)matchingEntries.get(i) + ")";
            }
            if (countOfHits != 0) {
                Object[] options;
                outputMessage = outputMessage + ".\n\nDo you want to replace ";
                outputMessage = countOfHits == 1 ? outputMessage + (String)matchingEntries.get(0) + " with your new entry " + input + "?" : outputMessage + "all old entries with your new entry " + input + "?";
                int answer = JOptionPane.showOptionDialog(this, outputMessage, "Value already in model", 0, 0, null, options = new Object[]{"Replace", "Cancel"}, options[1]);
                if (answer == 0) {
                    for (int i = 0; i < matchingEntries.size(); ++i) {
                        this.myModel.clearEntry(matchingEntries.get(i));
                    }
                    this.addEntry(input);
                }
            }
            StatusPanel.getInstance().setStatusMsg(e.getMessage());
            RmaDefs.getInstance().controlledBeep();
        }
    }

    private void handleDeleteAction(JTable table) {
        int response = JOptionPane.showConfirmDialog(this, "Delete selected entries?", "Delete", 0);
        if (response == 0) {
            int[] entries = table.getSelectedRows();
            for (int i = entries.length - 1; i >= 0; --i) {
                this.myModel.clearEntry(this.myModel.getEntryAt(entries[i]));
            }
        }
    }

    private void handleSearchAction(String inputSearch) {
        Pattern pattern = Pattern.compile("\\d*");
        Matcher matchBegin = pattern.matcher(inputSearch);
        if (matchBegin.matches()) {
            this.searchAndDisplayValueInModel(inputSearch);
        } else {
            StatusPanel.getInstance().setStatusMsg("You cannot search for this entry. (only digits allowed)");
            RmaDefs.getInstance().controlledBeep();
        }
    }

    private void setSearchPanelVisible(boolean showPanel) {
        this.mySearchPanel.setVisible(showPanel);
        if (this.myEditDialog != null) {
            this.mySearchPanelFrame.setVisible(showPanel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Window owner = GuiUtil.getClosestWindowParent(this);
        this.myEditDialog = new JDialog(owner, "Values", Dialog.ModalityType.APPLICATION_MODAL);
        this.myEditDialog.setName("TableVariable.JDialog.editDialog");
        this.myEditDialog.setMinimumSize(new Dimension(250, 200));
        this.myEditDialog.setLayout(new GridBagLayout());
        this.myEditDialog.add((Component)this.createPanel(true), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Component editor = this.myVariable.getEditor();
        int x = 0;
        int y = 0;
        try {
            Point renderLoc = editor.getLocationOnScreen();
            x = renderLoc.x - this.myEditDialog.getWidth() / 2;
            y = renderLoc.y - this.myEditDialog.getHeight() / 4;
        }
        catch (IllegalComponentStateException ex) {
            ex.printStackTrace();
            x = 0;
            y = 0;
        }
        this.myEditDialog.setLocation(x, y);
        this.myEditDialog.setVisible(true);
        this.myEditDialog.setDefaultCloseOperation(1);
    }

    private class ActionHandler {
        private JTextField myInputField;
        private JTable myInternalTable;
        private JButton myAddButton;
        private JButton myDeleteButton;
        private JButton myInternalSearchButton;
        private JButton myCancelSearchButton;
        KeyListener internalKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && e.getSource().equals(ActionHandler.this.myInputField)) {
                    TableVariablePanel.this.addEntry(ActionHandler.this.myInputField.getText());
                    ActionHandler.this.myInputField.setText("");
                } else if (e.getKeyCode() == 127 && e.getSource().equals(ActionHandler.this.myInternalTable)) {
                    TableVariablePanel.this.handleDeleteAction(ActionHandler.this.myInternalTable);
                    e.consume();
                } else if (e.getKeyCode() == 86) {
                    if (e.isControlDown() || (e.getModifiersEx() & 0x80) > 0) {
                        TableVariablePanel.this.handlePasteAction();
                    }
                    e.consume();
                } else if (e.getKeyCode() == 27) {
                    TableVariablePanel.this.myModel.setSearchFilter("");
                    TableVariablePanel.this.setSearchPanelVisible(false);
                } else if (e.getKeyCode() == 114) {
                    TableVariablePanel.this.handleSearchAction(ActionHandler.this.myInputField.getText());
                    TableVariablePanel.this.setSearchPanelVisible(true);
                }
            }
        };
        MouseListener internalMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent() == ActionHandler.this.myAddButton) {
                    TableVariablePanel.this.addEntry(ActionHandler.this.myInputField.getText());
                    ActionHandler.this.myInputField.setText("");
                } else if (mouseEvent.getComponent() == ActionHandler.this.myDeleteButton) {
                    TableVariablePanel.this.handleDeleteAction(ActionHandler.this.myInternalTable);
                } else if (mouseEvent.getComponent() == ActionHandler.this.myInternalSearchButton) {
                    TableVariablePanel.this.handleSearchAction(ActionHandler.this.myInputField.getText());
                    TableVariablePanel.this.setSearchPanelVisible(true);
                } else if (mouseEvent.getComponent() == ActionHandler.this.myCancelSearchButton) {
                    TableVariablePanel.this.handleSearchAction("");
                    TableVariablePanel.this.setSearchPanelVisible(false);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ActionHandler.this.myInternalTable.editCellAt(ActionHandler.this.myInternalTable.getSelectedRow(), 0);
                }
            }
        };

        public ActionHandler(JTextField field, JTable table, JButton add, JButton delete, JButton search, JButton cancelSearch) {
            this.myInputField = field;
            this.myInternalTable = table;
            this.myAddButton = add;
            this.myDeleteButton = delete;
            this.myInternalSearchButton = search;
            this.myCancelSearchButton = cancelSearch;
            this.myInputField.setName("TableVariable.JTextField.inputField");
            this.myInternalTable.setName("TableVariable.JDialog.tableDialog");
            this.myAddButton.setName("TableVariable.JButton.addButton");
            this.myDeleteButton.setName("TableVariable.JButton.deleteButton");
            this.myInternalSearchButton.setName("TableVariable.JButton.searchButton");
            this.myCancelSearchButton.setName("TableVariable.JButton.cancelButton");
            this.myInputField.addKeyListener(this.internalKeyListener);
            this.myInternalTable.addKeyListener(this.internalKeyListener);
            this.myInternalTable.addMouseListener(this.internalMouseListener);
            this.myAddButton.addMouseListener(this.internalMouseListener);
            this.myDeleteButton.addMouseListener(this.internalMouseListener);
            this.myInternalSearchButton.addMouseListener(this.internalMouseListener);
            this.myCancelSearchButton.addMouseListener(this.internalMouseListener);
        }
    }
}

