/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.vareditor.variable.BaseVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Node;

public class StringVariable
extends BaseVariable
implements DocumentListener,
FocusListener {
    protected String myValue;
    protected JComponent myRenderer = null;
    protected JComponent myEditor = null;
    protected Document myModel = null;

    public StringVariable(String label) {
        super(label);
        this.myValue = null;
    }

    public StringVariable(String label, String value) {
        super(label);
        this.myValue = value;
    }

    public StringVariable(String label, String value, Document doc) {
        super(label);
        this.myValue = value;
        this.myModel = doc;
        this.setEditorValue(value);
    }

    public StringVariable(String label, String value, Document doc, int alignment) {
        super(label);
        this.myValue = value;
        this.myModel = doc;
        this.setEditorValue(value);
        this.setHorizontalAlignment(alignment);
    }

    public StringVariable(StringVariable v) {
        super(v);
        this.myValue = v.myValue;
        this.myModel = v.myModel;
    }

    @Override
    public Object clone() {
        return new StringVariable(this);
    }

    @Override
    public String getValueString() {
        Object str = this.parseValueToObject(this.myValue);
        if (str != null) {
            return String.valueOf(str);
        }
        return this.myValue;
    }

    @Override
    public Object getValueObject() {
        if (this.myEditor != null) {
            String value = this.getEditorValue();
            return this.parseValueToObject(value);
        }
        return this.parseValueToObject(this.myValue);
    }

    protected Object parseValueToObject(String value) {
        return value;
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        ((JTextField)this.myRenderer).setHorizontalAlignment(alignment);
    }

    protected String getEditorValue() {
        return ((JTextComponent)this.myEditor).getText();
    }

    protected String getRawEditorValue() {
        return ((JTextComponent)this.myEditor).getText();
    }

    @Override
    public String getTypename() {
        return "String";
    }

    @Override
    public boolean isValueValid() {
        boolean modelIsProbablyFieldValidation;
        if (this.myValue == null) {
            return false;
        }
        if (this.myEditor != null && this.myModel instanceof FieldValidation) {
            String value = this.getEditorValue();
            return ((FieldValidation)((Object)this.myModel)).isValid(value == null ? null : value.toString());
        }
        boolean bl = modelIsProbablyFieldValidation = !this.defaultModelIsNotFieldValidation();
        if (this.hasModel() || modelIsProbablyFieldValidation) {
            this.createModel();
            if (this.myModel instanceof FieldValidation) {
                return ((FieldValidation)((Object)this.myModel)).isValid(this.myValue);
            }
        }
        return true;
    }

    protected final boolean hasModel() {
        return this.myModel != null;
    }

    protected boolean defaultModelIsNotFieldValidation() {
        return this.getClass() == StringVariable.class;
    }

    protected boolean isValueValid(String v) {
        if (v == null) {
            return false;
        }
        this.createModel();
        if (this.myModel != null && this.myModel instanceof FieldValidation) {
            return ((FieldValidation)((Object)this.myModel)).isValid(v);
        }
        return true;
    }

    @Override
    public Class<?> getValueClass() {
        return String.class;
    }

    @Override
    public int getFormat() {
        return 0;
    }

    @Override
    public Component getRenderer() {
        if (this.myRenderer == null) {
            this.createModel();
            this.myRenderer = new JTextField(this.myValue);
            ((JTextComponent)this.myRenderer).setDocument(this.myModel);
            ((JTextComponent)this.myRenderer).setText(this.myValue);
        }
        this.myRenderer.setEnabled(this.myEditIsAllowed);
        return this.myRenderer;
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myEditor != null;
    }

    @Override
    public Component getEditor() {
        if (this.myEditor == null) {
            this.createModel();
            this.myEditor = this.createEditor();
            this.myEditor.addFocusListener(this);
            if (this.myEditor instanceof JPasswordField) {
                this.setEditorValue("**************");
            } else {
                this.setEditorValue(this.myValue);
            }
            this.myModel.addDocumentListener(this);
        }
        this.setEditingAllowedOnEditor(this.myEditIsAllowed);
        this.setEditorBackgroundColor(this.isValueValid());
        return this.myEditor;
    }

    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new PlainDocument();
        }
    }

    @Override
    public Object getModel() {
        return this.myModel;
    }

    protected JTextComponent createEditor() {
        JTextField field = null;
        field = this.myLabel.equals("Password") ? new JPasswordField(this.myValue) : new JTextField(this.myValue);
        field.setName("InputTextField");
        return field;
    }

    protected void setEditingAllowedOnEditor(boolean allowed) {
        this.myEditor.setEnabled(allowed);
    }

    @Override
    protected void setVarValue(Object v) {
        this.setVarValue(v.toString());
    }

    @Override
    protected void setVarValue(String v) {
        if (this.isValueValid(v)) {
            this.myValue = v;
        }
        this.setEditorValue(v);
    }

    protected void setEditorValue(String v) {
        String valueToAssign = v;
        if (this.myEditor != null) {
            boolean isValid = this.isValueValid(valueToAssign);
            if (isValid) {
                valueToAssign = String.valueOf(this.parseValueToObject(valueToAssign));
            }
            if (this.myEditor instanceof JTextComponent) {
                ((JTextComponent)this.myEditor).setDocument(isValid ? this.myModel : new PlainDocument());
                this.setEditorBackgroundColor(isValid);
                ((JTextComponent)this.myEditor).setText(valueToAssign);
            }
        } else {
            this.myValue = valueToAssign;
        }
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        this.setKey(key);
        this.setValue(value);
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    private void handleDocumentEvent(DocumentEvent e) {
        String newValue = this.getEditorValue();
        if (this.isValueValid(newValue)) {
            this.setValueFromDocumentEvent(newValue);
        } else {
            this.setValueFromDocumentEvent(this.myValue);
        }
    }

    protected void setValueFromDocumentEvent(String value) {
        String oldValue = this.myValue;
        this.myValue = value;
        this.fireValueChanged(oldValue, this.myValue, this.isValueValid());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.isValueValid()) {
            JTextComponent editor = (JTextComponent)this.myEditor;
            String v = this.getRawEditorValue();
            this.setEditorBackgroundColor(true);
            editor.setDocument(this.myModel);
            if (this.myModel instanceof FieldValidation) {
                ((FieldValidation)((Object)this.myModel)).enableValidation(false);
                editor.setText(v);
                ((FieldValidation)((Object)this.myModel)).enableValidation(true);
            } else {
                editor.setText(v);
            }
        }
        ((JTextComponent)this.myEditor).selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object tempObj;
        String tempStr = ((JTextComponent)this.myEditor).getText();
        if (this.myValue != null && !this.myValue.equals(tempStr) && (tempObj = this.parseValueToObject(tempStr)) != null) {
            this.setValue(String.valueOf(tempObj));
        }
        this.setEditorBackgroundColor(this.isValueValid());
    }

    private void setEditorBackgroundColor(boolean isValid) {
        if (this.myEditor instanceof JTextComponent) {
            Color bgColor = isValid ? UIManager.getColor("TextField.background") : Color.RED;
            ((JTextComponent)this.myEditor).setBackground(bgColor);
        }
    }

    public void setModel(Document documentToUse) {
        this.myModel = documentToUse;
    }
}

