/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class RowIndexRenderer
implements TableCellRenderer {
    private Color selectedBGColor = Color.blue.brighter();
    private Color selectedFGColor = Color.white;
    private Color unSelectedBGColor = new Color(204, 204, 204);
    private Color unSelectedFGColor = new Color(102, 102, 204);
    private boolean shouldCorrectIndex;
    private transient JLabel myLabel = new JLabel();

    public RowIndexRenderer(boolean correctIndexForArray) {
        this.shouldCorrectIndex = correctIndexForArray;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            this.myLabel.setText("");
        } else if (value instanceof Integer) {
            String indexString = this.shouldCorrectIndex ? String.valueOf((Integer)value - 1) : String.valueOf(value);
            this.myLabel.setText(indexString);
        } else {
            this.myLabel.setText(value.toString());
        }
        this.myLabel.setOpaque(true);
        if (isSelected || table.getSelectedRow() == row) {
            this.myLabel.setBackground(this.selectedBGColor);
            this.myLabel.setForeground(this.selectedFGColor);
        } else if (hasFocus) {
            this.myLabel.setBackground(this.selectedBGColor);
            this.myLabel.setForeground(this.selectedFGColor);
        } else {
            this.myLabel.setBackground(this.unSelectedBGColor);
            this.myLabel.setForeground(this.unSelectedFGColor);
        }
        this.myLabel.setVerticalAlignment(1);
        return this.myLabel;
    }
}

