/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.gui.util.CalendarModel;
import com.ericsson.ere.gui.util.DatePanel;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.RelativeTime;

public class RelativeTimeVariable
extends DateAndTimeVariable {
    private RelativeTime myMinTime;
    private RelativeTime myMaxTime;

    public RelativeTimeVariable(String label, RelativeTime minTime, RelativeTime maxTime, RelativeTime defaultValue) {
        super(label);
        this.myMinTime = minTime;
        this.myMaxTime = maxTime;
        if (defaultValue != null) {
            if (this.myMinTime.compareTo(defaultValue) > 0 || this.myMaxTime.compareTo(defaultValue) < 0) {
                throw new IllegalArgumentException("The value is not in the allowed range");
            }
            this.myValue = defaultValue;
        } else {
            this.myValue = minTime;
        }
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        int hour;
        int day = 1;
        if (((RelativeTime)this.myValue).getHour() > 23) {
            day += ((RelativeTime)this.myValue).getHour() / 24;
            hour = ((RelativeTime)this.myValue).getHour() % 24;
        } else {
            hour = ((RelativeTime)this.myValue).getHour();
        }
        this.myPanelVariableEditor = new DatePanel(this.myMinTime, this.myMaxTime, new CalendarModel(2000, 1, day, hour, ((RelativeTime)this.myValue).getMinute(), ((RelativeTime)this.myValue).getSecond()), DatePanel.Mode.RELATIVE_MODE);
        ((DatePanel)this.myPanelVariableEditor).setAllowEdit(this.myEditIsAllowed);
        return this.myPanelVariableEditor;
    }

    @Override
    public Object clone() {
        assert (this.myValue instanceof RelativeTime);
        return new RelativeTimeVariable(this.myLabel, this.myMinTime, this.myMaxTime, (RelativeTime)this.myValue);
    }

    @Override
    public Object getValueObject() {
        if (this.myPanelVariableEditor != null) {
            return this.myPanelVariableEditor.getEditorValue();
        }
        return this.myValue;
    }

    @Override
    public String getValueString() {
        return ((RelativeTime)this.getValueObject()).toString();
    }

    @Override
    public void setVarValue(Object obj) {
        if (obj instanceof RelativeTime) {
            this.myValue = obj;
            if (this.myPanelVariableEditor != null) {
                ((DatePanel)this.myPanelVariableEditor).setRelativeTimeValue(this.createCalendarModelFromRelativeTime((RelativeTime)this.myValue));
            }
        } else if (obj instanceof String) {
            this.setVarValue((String)obj);
        } else {
            throw new IllegalArgumentException("Unhandled object in RelativeTimeVariable");
        }
    }

    @Override
    public void setVarValue(String v) {
        try {
            String[] split = v.split(":");
            int hours = Integer.parseInt(split[0]);
            int minutes = Integer.parseInt(split[1]);
            int seconds = Integer.parseInt(split[2]);
            this.myValue = new RelativeTime(hours, minutes, seconds);
            if (this.myPanelVariableEditor != null) {
                CalendarModel calendarModel = this.createCalendarModelFromRelativeTime((RelativeTime)this.myValue);
                ((DatePanel)this.myPanelVariableEditor).setValue(calendarModel.getCalendar());
                ((DatePanel)this.myPanelVariableEditor).updateEditorBackground();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong format of string, should be HHHH:mm:ss");
        }
    }

    private CalendarModel createCalendarModelFromRelativeTime(RelativeTime rTime) {
        int hour;
        int day = 1;
        if (rTime.getHour() > 24) {
            day += rTime.getHour() / 24;
            hour = rTime.getHour() % 24;
        } else {
            hour = rTime.getHour();
        }
        return new CalendarModel(2000, 1, day, hour, ((RelativeTime)this.myValue).getMinute(), ((RelativeTime)this.myValue).getSecond());
    }

    @Override
    public String toString() {
        if (this.myPanelVariableEditor != null) {
            return this.myPanelVariableEditor.getEditorValue().toString();
        }
        return ((RelativeTime)this.myValue).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelativeTimeVariable other = (RelativeTimeVariable)obj;
        if (this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue)) {
            return false;
        }
        if (this.myMinTime == null ? other.myMinTime != null : !this.myMinTime.equals(other.myMinTime)) {
            return false;
        }
        return !(this.myMaxTime == null ? other.myMaxTime != null : !this.myMaxTime.equals(other.myMaxTime));
    }
}

