/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.annotations.jcip.Immutable;

@Immutable
public class RelativeTime
implements Comparable<RelativeTime> {
    private static final int MAX_HOURS = 8759;
    private final int myHour;
    private final int myMinute;
    private final int mySecond;

    public RelativeTime(int hour, int minute, int second) {
        if (hour > 8759 || minute > 59 || second > 59) {
            throw new IllegalArgumentException();
        }
        this.myHour = hour;
        this.myMinute = minute;
        this.mySecond = second;
    }

    public int getHour() {
        return this.myHour;
    }

    public int getMinute() {
        return this.myMinute;
    }

    public int getSecond() {
        return this.mySecond;
    }

    public String toString() {
        return this.myHour + ":" + this.myMinute + ":" + this.mySecond;
    }

    @Override
    public int compareTo(RelativeTime obj) {
        int compareValue = this.myHour < obj.myHour ? -1 : (this.myHour == obj.myHour ? (this.myMinute < obj.myMinute ? -1 : (this.myMinute == obj.myMinute ? (this.mySecond < obj.mySecond ? -1 : (this.mySecond == obj.mySecond ? 0 : 1)) : 1)) : 1);
        return compareValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelativeTime other = (RelativeTime)obj;
        if (this.myHour != other.myHour) {
            return false;
        }
        if (this.myMinute != other.myMinute) {
            return false;
        }
        return this.mySecond == other.mySecond;
    }

    public static RelativeTime parseRelativeTime(String formattedString) {
        if (formattedString == null || !RelativeTime.stringInSupportedFormat(formattedString)) {
            return null;
        }
        String[] values = formattedString.split(":");
        try {
            int hour = Integer.parseInt(values[0]);
            int minute = Integer.parseInt(values[1]);
            int second = Integer.parseInt(values[2]);
            return new RelativeTime(hour, minute, second);
        }
        catch (Exception nfe) {
            return null;
        }
    }

    private static boolean stringInSupportedFormat(String stringToParse) {
        String[] values = stringToParse.split(":");
        if (values.length == 3) {
            return values[0].length() <= 4 && values[1].length() <= 2 && values[2].length() <= 2;
        }
        return false;
    }
}

