/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.math.RatingDecimal;
import ericsson.vareditor.documents.RatingDecimalDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class RatingDecimalVariable
extends AbstractNumberStringVariable {
    private RatingDecimal myMinValue;
    private RatingDecimal myMaxValue;
    private boolean myAllowEmpty;

    public RatingDecimalVariable(String label, RatingDecimal value) {
        super(label);
        this.myValue = value.toString();
        this.myAllowEmpty = false;
    }

    public RatingDecimalVariable(String label, String value, RatingDecimal minValue, RatingDecimal maxValue) {
        this(label, value, minValue, maxValue, false);
    }

    public RatingDecimalVariable(String label, String value, RatingDecimal minValue, RatingDecimal maxValue, boolean allowEmpty) {
        super(label, value);
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
        this.myAllowEmpty = allowEmpty;
    }

    public RatingDecimalVariable(String label, String value) {
        super(label, value);
    }

    public RatingDecimalVariable(RatingDecimalVariable v) {
        super(v);
        this.myValue = v.myValue;
    }

    @Override
    public Object clone() {
        return new RatingDecimalVariable(this);
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(value)) {
            return new RatingDecimal(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "RatingDecimal";
    }

    public Class<RatingDecimal> getValueClass() {
        return RatingDecimal.class;
    }

    @Override
    public int getFormat() {
        return 3000;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = this.myMinValue != null && this.myMaxValue != null ? new RatingDecimalDocument(this.myAllowEmpty, this.myMinValue.isLessThanZero(), this.myMinValue, this.myMaxValue) : new RatingDecimalDocument(this.myAllowEmpty, true);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

