/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.RangeObject;
import ericsson.vareditor.variable.RangeVariablePanel;
import java.io.PrintWriter;

public class RangeVariable
extends PanelVariable {
    private DataType myDataType = null;
    private boolean myShowCheckBoxes = false;

    public RangeVariable(String aLabel, boolean showCheckBoxes) {
        super(aLabel);
        this.myShowCheckBoxes = showCheckBoxes;
        this.myDataType = DataType.LONG;
        this.myValue = RangeVariablePanel.createDefaultRangeObject(this.myDataType);
    }

    public RangeVariable(String aLabel, String dataType, boolean showCheckBoxes) {
        super(aLabel);
        DataType dt = DataType.lookup(dataType);
        if (!this.dataTypeValid(dt)) {
            throw new IllegalArgumentException("RangeVariable can not handle data type " + dt + " without minimum and maximum values.");
        }
        this.myDataType = dt;
        this.myShowCheckBoxes = dt == DataType.RATINGDECIMAL ? false : showCheckBoxes;
        this.myValue = RangeVariablePanel.createDefaultRangeObject(this.myDataType);
    }

    private boolean dataTypeValid(DataType dt) {
        return dt != DataType.DECIMAL;
    }

    public RangeVariable(String aLabel, String dataType, String startMinValue, String startMaxValue, boolean showCheckBoxes) {
        super(aLabel);
        this.myDataType = DataType.lookup(dataType);
        this.myShowCheckBoxes = this.myDataType == DataType.RATINGDECIMAL ? false : showCheckBoxes;
        this.myValue = RangeVariablePanel.createRangeObject(this.myDataType, startMinValue, startMaxValue);
    }

    private RangeVariable(RangeVariable var) {
        super(var);
        this.myDataType = var.myDataType;
        this.myShowCheckBoxes = var.myShowCheckBoxes;
        this.myValue = RangeVariablePanel.createRangeObject(this.myDataType, var.getMinValue(), var.getMaxValue());
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        if (this.myPanelVariableEditor == null) {
            RangeObject ro = (RangeObject)this.myValue;
            this.myPanelVariableEditor = new RangeVariablePanel(this, this.myDataType, ro.getMinValue(), ro.getMaxValue(), this.myShowCheckBoxes);
        }
        return this.myPanelVariableEditor;
    }

    @Override
    protected void validate() {
        this.myIsValid = this.myPanelVariableEditor != null ? this.myPanelVariableEditor.isEditorValueValid() : true;
    }

    @Override
    public Object clone() {
        return new RangeVariable(this);
    }

    public String getMinValue() {
        if (this.myPanelVariableEditor != null) {
            return ((RangeVariablePanel)this.myPanelVariableEditor).getMinValue();
        }
        return ((RangeObject)this.myValue).getMinValue();
    }

    public String getMaxValue() {
        if (this.myPanelVariableEditor != null) {
            return ((RangeVariablePanel)this.myPanelVariableEditor).getMaxValue();
        }
        return ((RangeObject)this.myValue).getMaxValue();
    }

    public void setEditorChanged() {
        if (this.myDataItem != null) {
            this.dataChanged();
        }
    }

    @Override
    public void setAllowEdit(boolean allow) {
        this.myEditIsAllowed = allow;
        ((RangeVariablePanel)this.createPanelVariableEditor()).setAllowEdit(allow);
    }

    @Override
    public String getTypename() {
        return this.myDataType.getTypeName();
    }

    @Override
    public Class<?> getValueClass() {
        return this.myDataType.getTypeClass();
    }

    @Override
    public Object getValueObject() {
        if (this.myPanelVariableEditor != null) {
            this.myValue = this.myPanelVariableEditor.getEditorValue();
        }
        return this.myValue;
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.getValueObject());
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
    }

    @Override
    protected void setVarValue(Object v) {
        if (!(v instanceof RangeObject)) {
            throw new IllegalArgumentException("RangeVariable: Parameter v is malformed.");
        }
        this.myValue = v;
        if (this.myPanelVariableEditor != null) {
            RangeObject ro = (RangeObject)v;
            ((RangeVariablePanel)this.myPanelVariableEditor).setEditorValue(ro.getMinValue(), ro.getMaxValue());
        }
    }

    @Override
    protected void setVarValue(String v) {
        try {
            String[] splitValue = v.split(" - ");
            this.myDataType.parseValue(splitValue[0]);
            this.myDataType.parseValue(splitValue[1]);
            RangeObject newObject = new RangeObject(this.myDataType.isIntegerNumeric(), splitValue[0], splitValue[1]);
            this.myValue = newObject;
            if (this.myPanelVariableEditor != null) {
                ((RangeVariablePanel)this.myPanelVariableEditor).setEditorValue(splitValue[0], splitValue[1]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("RangeVariable: String parameter v is malformed.");
        }
    }
}

