/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.annotations.jcip.Immutable;
import java.math.BigDecimal;
import java.math.BigInteger;

@Immutable
public class RangeObject
implements Cloneable {
    private final Object myMinValue;
    private final Object myMaxValue;

    public RangeObject(boolean isInteger, String minValue, String maxValue) {
        try {
            if (isInteger) {
                this.myMinValue = new BigInteger(minValue);
                this.myMaxValue = new BigInteger(maxValue);
            } else {
                this.myMinValue = new BigDecimal(minValue);
                this.myMaxValue = new BigDecimal(maxValue);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("RangeObject: Can not parse parameter values.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RangeObject clone = (RangeObject)super.clone();
        return clone;
    }

    public String getMinValue() {
        return this.myMinValue.toString();
    }

    public String getMaxValue() {
        return this.myMaxValue.toString();
    }

    public String toString() {
        return this.myMinValue + " - " + this.myMaxValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myMaxValue == null ? 0 : this.myMaxValue.hashCode());
        result = 31 * result + (this.myMinValue == null ? 0 : this.myMinValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeObject other = (RangeObject)obj;
        if (this.myMaxValue == null ? other.myMaxValue != null : !this.myMaxValue.equals(other.myMaxValue)) {
            return false;
        }
        return !(this.myMinValue == null ? other.myMinValue != null : !this.myMinValue.equals(other.myMinValue));
    }
}

