/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.util.ArrayEditPanel;
import com.ericsson.ere.gui.util.ArrayEditPanelBuilder;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.ArrayVariableBase;
import java.awt.Component;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class PlainCollectionVariable
extends ArrayVariableBase {
    private ArrayEditPanel myEditPanel;

    public PlainCollectionVariable(String label, Object[] value, ValueResolver resolver, FieldHierarchyNode.ComplexType complexType) {
        this(label, new ArrayModel(value), resolver, complexType);
    }

    public PlainCollectionVariable(String label, ArrayModel model, ValueResolver resolver, FieldHierarchyNode.ComplexType complexType) {
        super(label, model);
        this.setValueResolver(resolver);
        this.setForceArrayEdit(complexType == FieldHierarchyNode.ComplexType.ARRAY);
    }

    private PlainCollectionVariable(PlainCollectionVariable variable) {
        super(variable.getLabel(), PlainCollectionVariable.cloneModel(variable.getModel()));
        this.setValueResolver(variable.getValueResolver());
        this.setObjectLabeler(variable.getObjectLabeler());
        this.setForceArrayEdit(variable.getForceArrayEdit());
        this.setVariableProducer(variable.getVariableProducer());
    }

    @Override
    protected void modelChanged(ArrayModel newModel) {
        this.updateGui(newModel);
    }

    @Override
    public String getValueString() {
        return ArrayVariable.createValueString(this.getValueResolver(), this.getModel().toArray());
    }

    public ArrayEditPanel getArrayEditPanel() {
        if (this.myEditPanel == null) {
            ArrayEditPanelBuilder builder = this.createBuilderForEditPanel();
            this.myEditPanel = builder.createPanel();
        }
        return this.myEditPanel;
    }

    @Override
    public Object clone() {
        return new PlainCollectionVariable(this);
    }

    @Override
    public Object getValueObject() {
        return this.getModel();
    }

    private void updateGui(final ArrayModel newModel) {
        if (this.myEditPanel != null) {
            EDT.runAndWait(new Runnable(){

                @Override
                public void run() {
                    PlainCollectionVariable.this.myEditPanel.updatePanelWithModel(newModel);
                }
            });
        }
    }

    @Override
    public void setVarValue(Object v) {
        if (v instanceof Object[]) {
            Object[] values = (Object[])v;
            this.setModel(new ArrayModel(values));
        }
        if (v instanceof String) {
            this.setVarValue((String)v);
        }
        if (v instanceof ArrayModel) {
            this.setModel((ArrayModel)v);
        }
    }

    public String getDataType() {
        return this.getValueResolver().getDataType().getTypeName();
    }

    @Override
    protected String getXMLValueString() {
        return "";
    }

    @Override
    protected void setVarValue(String v) {
        String str = v.trim();
        if (str.startsWith("<Array") && str.endsWith("</Array>")) {
            try {
                Element element = XMLUtil.buildDocumentFromString("<Wrapper>" + str + "</Wrapper>").getDocumentElement();
                this.initFromXml(element, "", this.myKey, this.getFormat());
            }
            catch (Exception e) {
                this.setModel(new ArrayModel(new Object[0]));
            }
        } else {
            DataType dataType = DataType.lookup(this.getDataType());
            ArrayList<Object> valueList = new ArrayList<Object>();
            StringTokenizer st = new StringTokenizer(str, ";");
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                if ("null".equals(next)) continue;
                valueList.add(dataType.parseValue(next));
            }
            ArrayModel model = valueList.size() == 0 ? this.getModel().createEmptyModelOfCurrentType() : new ArrayModel(dataType.createArray(valueList.toArray()));
            this.setModel(model);
        }
    }

    @Override
    public Component getRenderer() {
        return this.getEditor();
    }

    @Override
    public Component getEditor() {
        return this.getArrayEditPanel();
    }
}

