/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.OctetString;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.components.OctetStringPanel;
import ericsson.vareditor.documents.PlainHexAsciiDocument;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OctetStringVariable
extends PanelVariable {
    private boolean myIsHexMode = true;
    private final PlainHexAsciiDocument myValidationDocument = new PlainHexAsciiDocument();
    public static final int HEX_MODE = 0;
    public static final int ASCII_MODE = 1;

    public OctetStringVariable(String label, OctetString value) {
        super(label, (Object)OctetStringVariable.copyOf(value));
    }

    private static OctetString copyOf(OctetString value) {
        return new OctetString(value.getData());
    }

    public OctetStringVariable(String label, OctetString value, int mode) {
        this(label, value);
        this.myIsHexMode = mode == 0;
    }

    @Deprecated
    public OctetStringVariable(String label, String value, int mode) {
        this(label, OctetStringVariable.stringToOctetString(value, mode == 0), mode);
    }

    public OctetStringVariable(OctetStringVariable v) {
        super(v);
        this.myIsHexMode = v.myIsHexMode;
    }

    @Override
    public String getTypename() {
        return "OctetString";
    }

    @Override
    public Class<?> getValueClass() {
        return OctetString.class;
    }

    @Override
    public int getFormat() {
        return 2020;
    }

    public boolean getMode() {
        return this.myIsHexMode;
    }

    public String getModeAsString() {
        return this.getMode() ? "Hex" : "Ascii";
    }

    public void setMode(boolean aMode) {
        if (this.myIsHexMode != aMode) {
            this.myIsHexMode = aMode;
            if (this.hasEditor()) {
                ((OctetStringPanel)this.getEditor()).setHexMode(this.myIsHexMode);
            }
        }
    }

    public void setModeAsString(String aMode) {
        if ("Hex".equalsIgnoreCase(aMode)) {
            this.setMode(true);
        } else if ("Ascii".equalsIgnoreCase(aMode)) {
            this.setMode(false);
        }
    }

    private boolean hasEditor() {
        return this.myPanelVariableEditor != null;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        OctetStringPanel editor = new OctetStringPanel((OctetString)this.getValueObject(), this.myIsHexMode);
        editor.setReadOnly(!this.myEditIsAllowed);
        return editor;
    }

    @Override
    public Object clone() {
        OctetStringVariable clone = new OctetStringVariable(this);
        clone.myPanelVariableEditor = null;
        return clone;
    }

    @Override
    protected void validate() {
        this.myValidationDocument.setHexMode(this.myIsHexMode);
        this.setValid(this.myValidationDocument.isValid(this.getValueString()));
    }

    @Override
    public void dataChanged() {
        this.myIsHexMode = ((OctetStringPanel)this.getPanelVariableEditor()).getMode();
        super.dataChanged();
    }

    @Override
    public void setFocusListenerForEditor(FocusListener fl) {
        super.setFocusListenerForEditor(fl);
        ((OctetStringPanel)this.getPanelVariableEditor()).setFocusListenerForEditor(fl);
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        NodeList childNodes = node.getChildNodes();
        Element modeNode = XMLUtil.getNamedElement("Mode", childNodes);
        if (modeNode != null) {
            String mode = modeNode.getTextContent();
            this.setModeAsString(mode);
        }
        this.setValue(OctetStringVariable.stringToOctetString(value, this.myIsHexMode));
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
    }

    @Override
    public Object getValueObject() {
        return OctetStringVariable.copyOf((OctetString)this.myValue);
    }

    public static OctetString stringToOctetString(String s, boolean hex) {
        return hex ? OctetString.valueOf(s) : OctetString.fromAscii(s);
    }

    @Override
    protected void setVarValue(Object v) {
        if (v instanceof OctetString) {
            this.myValue = v;
            if (!this.myIsHexMode && this.hasEditor()) {
                ((OctetStringPanel)this.getPanelVariableEditor()).setValue(new OctetString(""));
            }
            this.setMode(true);
            if (this.hasEditor()) {
                ((OctetStringPanel)this.getPanelVariableEditor()).setValue((OctetString)v);
            }
        } else {
            this.setVarValue(v.toString());
        }
    }

    @Override
    protected void setVarValue(String v) {
        this.setVarValue(OctetString.valueOf(v));
    }

    @Override
    public String toString() {
        Object valueObject = this.myValue;
        String string = valueObject.toString();
        return string.length() > 0 ? "0x" + string : string;
    }
}

