/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.dataitem.DataItem;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.components.MultiplerSelectEditorPanel;
import ericsson.vareditor.components.SelectableMultipler;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiplierSelectEditorVariable
extends PanelVariable {
    private String mySelectedDropdown = "";
    SelectableMultipler[] mySelections;
    private int myDataType;
    private boolean allowEmpty;
    private String myLocalId;
    private Number myMax;
    private Number myMin;

    public MultiplierSelectEditorVariable(String label, String value, String selected, SelectableMultipler[] selections, int dataType) {
        this(label, value, selected, selections, dataType, false);
    }

    public MultiplierSelectEditorVariable(String label, String value, String selected, SelectableMultipler[] selections, int dataType, boolean allowEmpty) {
        this(label, value, selected, selections, dataType, allowEmpty, null, null);
    }

    public MultiplierSelectEditorVariable(String label, String value, String selected, SelectableMultipler[] selections, int dataType, boolean allowEmpty, Number min, Number max) {
        super(label, (Object)value);
        this.mySelectedDropdown = selected != null ? selected : "";
        this.mySelections = selections;
        this.myDataType = dataType;
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public String getTypename() {
        return "MultiplierSelectEditor";
    }

    @Override
    public Class<?> getValueClass() {
        Class valueClass = this.myDataType == 8 ? Double.class : (this.myDataType == 7 ? Long.class : Integer.class);
        return valueClass;
    }

    @Override
    public int getFormat() {
        return this.myDataType;
    }

    @Override
    public StringBuffer getXMLDefinition(String xmlTag) {
        StringBuffer xml = new StringBuffer("Default=\"" + this.getValueString() + "\" ");
        xml.append(MultiplerSelectEditorPanel.TAG_UNIT_FACTOR + "=\"" + ((MultiplerSelectEditorPanel)this.myPanelVariableEditor).getSelected() + "\"");
        return xml;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        if (this.myPanelVariableEditor != null) {
            return this.myPanelVariableEditor;
        }
        MultiplerSelectEditorPanel editorPanel = new MultiplerSelectEditorPanel(this.mySelections, "" + this.myValue, this.mySelectedDropdown, this.myDataType, this.allowEmpty, this.myMin, this.myMax);
        editorPanel.setEditorListener(this);
        return editorPanel;
    }

    @Override
    public Object clone() {
        return new MultiplierSelectEditorVariable("", this.myValue.toString(), this.mySelectedDropdown, this.mySelections, this.myDataType, this.allowEmpty, this.myMin, this.myMax);
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        NodeList childNodes = node.getChildNodes();
        Element modeNode = XMLUtil.getNamedElement(MultiplerSelectEditorPanel.TAG_UNIT_FACTOR, childNodes);
        String mode = modeNode.getTextContent();
        MultiplerSelectEditorPanel editor = (MultiplerSelectEditorPanel)this.getEditor();
        editor.setSelected(mode);
        editor.setValue(value);
        this.setValue(value);
        this.validate();
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
        if (this.myPanelVariableEditor == null) {
            return;
        }
        ((MultiplerSelectEditorPanel)this.myPanelVariableEditor).writeXML(out);
    }

    @Override
    public Object getValueObject() {
        if (this.myPanelVariableEditor == null) {
            return this.myValue;
        }
        return this.myPanelVariableEditor.getEditorValue();
    }

    public String getXmlDescriptionOfInterval() {
        StringBuffer out = new StringBuffer();
        out.append("<");
        out.append(MultiplerSelectEditorPanel.TAG_UNIT_FACTOR);
        out.append(">");
        out.append(this.getSelectedFactorFromSuffix());
        out.append("</");
        out.append(MultiplerSelectEditorPanel.TAG_UNIT_FACTOR);
        out.append(">");
        return out.toString();
    }

    public String getSelectedFactorFromSuffix() {
        if (this.myPanelVariableEditor == null) {
            return this.mySelectedDropdown;
        }
        return String.valueOf(((MultiplerSelectEditorPanel)this.myPanelVariableEditor).getSelected().getMultiplier());
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.getValueObject());
    }

    @Override
    public String getMultipleSelectValueString() {
        return (String.valueOf(this.getValueObject()) + " " + this.getReadableUnitSuffix()).trim();
    }

    @Override
    public String toString() {
        return this.getValueString();
    }

    public String getReadableUnitSuffix() {
        if (this.myPanelVariableEditor == null) {
            for (int i = 0; i < this.mySelections.length; ++i) {
                SelectableMultipler panel = this.mySelections[i];
                if (this.mySelectedDropdown == null || !this.mySelectedDropdown.equals(panel.getMultiplier().toString())) continue;
                return panel.getLabel();
            }
            return this.mySelections[0].getLabel();
        }
        return ((MultiplerSelectEditorPanel)this.myPanelVariableEditor).getSelected().getLabel();
    }

    @Override
    protected void validate() {
        if (this.myPanelVariableEditor != null) {
            this.setValid(this.myPanelVariableEditor.isEditorValueValid());
        }
    }

    @Override
    public void setFocusListenerForEditor(FocusListener fl) {
    }

    public void setLocalId(String key) {
        this.myLocalId = key;
    }

    public String getLocalId() {
        return this.myLocalId;
    }

    @Override
    public void dataChanged() {
        String selected;
        this.mySelectedDropdown = selected = ((MultiplerSelectEditorPanel)this.myPanelVariableEditor).getSelected().getMultiplier().toString();
        super.dataChanged();
    }

    @Override
    public void setDataItem(DataItem item) {
        if (item == null && this.myPanelVariableEditor != null && ((MultiplerSelectEditorPanel)this.myPanelVariableEditor).isModified()) {
            super.dataChanged();
        }
        super.setDataItem(item);
    }

    @Override
    protected void setEditorValue() {
        if (this.myPanelVariableEditor != null) {
            ((MultiplerSelectEditorPanel)this.myPanelVariableEditor).setValue(this.myValue.toString());
        }
    }
}

