/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.documents.FieldValidation;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.actions.EditMultilineStringAction;
import ericsson.vareditor.variable.StringVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class MultilineStringVariable
extends StringVariable
implements KeyListener {
    JTextArea myTextArea;
    FocusListener myFocusListener = null;
    private boolean myDetachedEditorAvailable = true;
    private JButton myOpenDetachedEditorButton;

    public MultilineStringVariable(String label, String value) {
        super(label, value);
    }

    public MultilineStringVariable(String label, String value, Document doc) {
        super(label, value, doc);
    }

    public MultilineStringVariable(MultilineStringVariable v) {
        super(v);
    }

    @Override
    protected boolean defaultModelIsNotFieldValidation() {
        return true;
    }

    @Override
    public Object clone() {
        return new MultilineStringVariable(this);
    }

    @Override
    protected String getEditorValue() {
        return this.myTextArea.getText();
    }

    @Override
    protected Object parseValueToObject(String value) {
        return XMLUtil.escape(value);
    }

    @Override
    public Component getRenderer() {
        if (this.myRenderer == null) {
            JTextArea textArea = new JTextArea(this.myValue, 5, 20);
            textArea.setLineWrap(false);
            this.myRenderer = textArea;
        } else {
            ((JTextArea)this.myRenderer).setText(this.myValue);
        }
        return this.myRenderer;
    }

    @Override
    public Component getEditor() {
        if (this.myEditor == null) {
            this.createModel();
            this.myTextArea = new JTextArea(this.myValue, 5, 20);
            this.myTextArea.setLineWrap(false);
            this.myTextArea.addFocusListener(this);
            JScrollPane pane = new JScrollPane(this.myTextArea, 22, 32);
            pane.setFocusable(false);
            pane.getHorizontalScrollBar().setFocusable(false);
            pane.getVerticalScrollBar().setFocusable(false);
            this.myOpenDetachedEditorButton = new JButton("...");
            this.myOpenDetachedEditorButton.setName("JButton.openDetachedEditor");
            this.myOpenDetachedEditorButton.setFocusable(false);
            this.myOpenDetachedEditorButton.setBorderPainted(false);
            this.myOpenDetachedEditorButton.setToolTipText("Edit " + this.myLabel);
            this.myOpenDetachedEditorButton.addActionListener(new EditMultilineStringAction(this));
            this.myOpenDetachedEditorButton.setVisible(this.myDetachedEditorAvailable);
            pane.setCorner("LOWER_RIGHT_CORNER", this.myOpenDetachedEditorButton);
            this.myEditor = pane;
            this.setEditorValue(this.myValue);
            this.myModel.addDocumentListener(this);
            this.myTextArea.addKeyListener(this);
        }
        this.myTextArea.setEnabled(this.myEditIsAllowed);
        return this.myEditor;
    }

    @Override
    protected void setEditorValue(String v) {
        if (this.myEditor != null) {
            boolean isValid = this.isValueValid(v);
            if (isValid) {
                this.myTextArea.setDocument(this.myModel);
                this.myTextArea.setText(v);
            } else {
                this.myTextArea.setDocument(this.myModel != null ? this.myModel : new PlainDocument());
                if (this.myModel instanceof FieldValidation) {
                    ((FieldValidation)((Object)this.myModel)).enableValidation(false);
                    this.myTextArea.setText(v);
                    ((FieldValidation)((Object)this.myModel)).enableValidation(true);
                }
            }
            this.myTextArea.setBackground(isValid ? UIManager.getColor("TextArea.background") : Color.RED);
        }
    }

    @Override
    public void setFocusListenerForEditor(FocusListener fl) {
        this.myFocusListener = fl;
        this.getEditor();
        this.myTextArea.addFocusListener(this);
    }

    @Override
    public int getFormat() {
        return 4;
    }

    @Override
    protected String getRawEditorValue() {
        return this.myTextArea.getText();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.isValueValid()) {
            this.myTextArea.setBackground(UIManager.getColor("TextArea.background"));
        }
        this.myTextArea.selectAll();
        if (this.myFocusListener != null) {
            focusEvent.setSource(this.getEditor());
            this.myFocusListener.focusGained(focusEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.myTextArea.setBackground(this.isValueValid() ? UIManager.getColor("TextArea.background") : Color.RED);
    }

    @Override
    public Component getDefaultFocusableEditor() {
        return this.myTextArea;
    }

    public void setDetachedEditorAvailable(boolean available) {
        if (available != this.myDetachedEditorAvailable) {
            this.myDetachedEditorAvailable = available;
            if (this.myOpenDetachedEditorButton != null) {
                EDT.runAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MultilineStringVariable.this.myOpenDetachedEditorButton.setVisible(MultilineStringVariable.this.myDetachedEditorAvailable);
                    }
                });
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        try {
            if (e.isControlDown() && e.isShiftDown() && e.getKeyCode() == 9) {
                this.moveFocusToComponentBeforeVariableEditor();
            } else if (e.isControlDown() && (e.getKeyCode() == 10 || e.getKeyCode() == 9)) {
                this.moveFocusToComponentAfterVariableEditor();
            } else if (e.getKeyCode() == 38) {
                if (this.myTextArea.getCaretPosition() == 0) {
                    this.moveFocusToComponentBeforeVariableEditor();
                } else if (this.myTextArea.getCaretPosition() <= this.myTextArea.getLineEndOffset(0)) {
                    this.myTextArea.setCaretPosition(0);
                }
            } else if (e.getKeyCode() == 40) {
                if (this.myTextArea.getCaretPosition() == this.myTextArea.getDocument().getLength()) {
                    this.moveFocusToComponentAfterVariableEditor();
                } else if (this.myTextArea.getCaretPosition() >= this.myTextArea.getLineStartOffset(this.myTextArea.getLineCount() - 1)) {
                    this.myTextArea.setCaretPosition(this.myTextArea.getLineEndOffset(this.myTextArea.getLineCount() - 1));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

