/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class LongVariable
extends AbstractNumberStringVariable {
    protected long myMinValue;
    protected long myMaxValue;
    protected boolean allowEmpty;

    public LongVariable(String label, long value) {
        super(label);
        this.myValue = String.valueOf(value);
        this.myMinValue = Long.MIN_VALUE;
        this.myMaxValue = Long.MAX_VALUE;
        this.allowEmpty = false;
    }

    public LongVariable(String label, String value) {
        super(label, value);
        this.myMinValue = Long.MIN_VALUE;
        this.myMaxValue = Long.MAX_VALUE;
        this.allowEmpty = false;
    }

    public LongVariable(String label, long value, long min, long max) {
        super(label);
        this.myValue = String.valueOf(value);
        this.myMinValue = min;
        this.myMaxValue = max;
        this.allowEmpty = false;
    }

    public LongVariable(String label, long value, long min, long max, boolean allowEmpty) {
        super(label);
        this.myValue = String.valueOf(value);
        this.myMinValue = min;
        this.myMaxValue = max;
        this.allowEmpty = allowEmpty;
    }

    public LongVariable(String label, String value, long min, long max) {
        super(label, value);
        this.myMinValue = min;
        this.myMaxValue = max;
        this.allowEmpty = false;
    }

    public LongVariable(String label, String value, long min, long max, boolean allowEmpty) {
        super(label, value);
        this.myMinValue = min;
        this.myMaxValue = max;
        this.allowEmpty = allowEmpty;
    }

    public LongVariable(LongVariable v) {
        super(v);
        this.myValue = v.myValue;
        this.myMinValue = v.myMinValue;
        this.myMaxValue = v.myMaxValue;
        this.allowEmpty = v.allowEmpty;
    }

    @Override
    public Object clone() {
        return new LongVariable(this);
    }

    @Override
    protected String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        if ("-".equals(value)) {
            return value;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.allowEmpty && (this.myValue == null || this.myValue.length() == 0)) {
            return "";
        }
        if (this.isValueValid(value)) {
            return Long.valueOf(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "Long";
    }

    public Class<Long> getValueClass() {
        return Long.class;
    }

    @Override
    public int getFormat() {
        return 7;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new NumbersOnlyDocument(this.myMinValue, this.myMaxValue, this.allowEmpty);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

