/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.ListVariableEditor;
import ericsson.vareditor.variable.TypedDropDownVariable;
import java.awt.Component;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Node;

public class ListVariable<T>
extends BaseVariable {
    private final TypedDropDownVariable.ItemLabeler<T> myLabeler;
    private final T[] myItems;
    private final boolean myMustHaveSelection;
    private final ListSelectionModel myListSelectionModel;
    private boolean myHasNonExistingSelection;
    private ListVariableEditor<T> myEditor;
    private boolean myIsSettingSelection;

    public ListVariable(String label, T[] items, boolean enablemultiselect, boolean mustHaveSelection) {
        this(label, items, null, new ToStringLabeler(), enablemultiselect, mustHaveSelection);
    }

    public ListVariable(String label, T[] items, T[] selected, boolean enableMultiSelect, boolean mustHaveSelection) {
        this(label, items, selected, new ToStringLabeler(), enableMultiSelect, mustHaveSelection);
    }

    public ListVariable(String label, T[] items, T[] selected, TypedDropDownVariable.ItemLabeler<T> labeler, boolean enableMultiSelect, boolean mustHaveSelection) {
        super(label);
        if (items == null) {
            throw new IllegalArgumentException("Items can not be null");
        }
        this.myItems = (Object[])items.clone();
        this.myLabeler = labeler;
        this.myMustHaveSelection = mustHaveSelection;
        this.myListSelectionModel = this.createSelectionModel(enableMultiSelect);
        this.setSelectedItems(selected);
    }

    protected T[] getItems() {
        return this.myItems;
    }

    public List<T> getAllItems() {
        return new ArrayList<T>(Arrays.asList(this.myItems));
    }

    protected boolean mustHaveSelection() {
        return this.myMustHaveSelection;
    }

    protected TypedDropDownVariable.ItemLabeler<T> getItemLabeler() {
        return this.myLabeler;
    }

    private ListSelectionModel createSelectionModel(boolean enableMultiSelect) {
        DefaultListSelectionModel model = new DefaultListSelectionModel();
        model.setSelectionMode(enableMultiSelect ? 2 : 0);
        model.addListSelectionListener(new SelectionListener());
        return model;
    }

    private int indexOf(T item) {
        int index = -1;
        for (int i = 0; i < this.myItems.length; ++i) {
            if (!this.myItems[i].equals(item)) continue;
            index = i;
            break;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedItems(T[] selected) {
        if (selected != null) {
            if (selected.length > 1 && !this.supportsMultiSelection()) {
                throw new IllegalArgumentException("Can not set more than one item as selected when variable is created with multi selection disabled.");
            }
            this.myIsSettingSelection = true;
            try {
                this.clearSelection();
                for (T selectedItem : selected) {
                    int index = this.indexOf(selectedItem);
                    this.updateSelection(index >= 0, index);
                }
            }
            finally {
                this.myIsSettingSelection = false;
            }
        }
    }

    private void setSelectedItems(List<String> selected) {
        if (selected != null) {
            Object[] items = new Object[selected.size()];
            int j = 0;
            for (int i = 0; i < this.myItems.length; ++i) {
                String description = this.myLabeler.getDisplayStringFor(this.myItems[i], i);
                if (!selected.contains(description)) continue;
                items[j++] = this.myItems[i];
            }
            Object[] items2 = Arrays.copyOf(items, j);
            this.setSelectedItems(items2);
        }
    }

    private void updateSelection(boolean itemExists, int index) {
        if (itemExists) {
            this.myListSelectionModel.addSelectionInterval(index, index);
        } else {
            this.myHasNonExistingSelection = true;
        }
    }

    private boolean supportsMultiSelection() {
        return this.myListSelectionModel.getSelectionMode() == 2;
    }

    @Override
    public Object clone() {
        List<T> selectedItems = this.getSelectedItems();
        Object[] selected = selectedItems.toArray();
        return new ListVariable<Object>(this.getLabel(), this.myItems, selected, this.myLabeler, this.supportsMultiSelection(), this.myMustHaveSelection);
    }

    @Override
    public int getFormat() {
        return 6000;
    }

    @Override
    public String getTypename() {
        return "List";
    }

    @Override
    public Class<?> getValueClass() {
        return List.class;
    }

    @Override
    public String getValueString() {
        StringBuilder valueStringBuilder = new StringBuilder();
        for (int i = 0; i < this.myItems.length; ++i) {
            if (!this.myListSelectionModel.isSelectedIndex(i)) continue;
            String description = this.myLabeler.getDisplayStringFor(this.myItems[i], i);
            valueStringBuilder.append(description.toString());
            valueStringBuilder.append(";");
        }
        return valueStringBuilder.toString();
    }

    @Override
    public Object getValueObject() {
        return this.getSelectedItems();
    }

    public List<T> getSelectedItems() {
        ArrayList<T> selected = new ArrayList<T>();
        for (int i = 0; i < this.myItems.length; ++i) {
            if (!this.myListSelectionModel.isSelectedIndex(i)) continue;
            selected.add(this.myItems[i]);
        }
        return selected;
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
    }

    @Override
    protected void setVarValue(Object v) {
        Object[] items;
        if (v.getClass().isArray()) {
            items = (Object[])v;
        } else {
            List list = (List)v;
            items = list.toArray();
        }
        this.setSelectedItems(items);
    }

    @Override
    protected void setVarValue(String v) {
        StringTokenizer tokenizer = new StringTokenizer(v, ";");
        ArrayList<String> selectedItemLabels = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String selectedItem = tokenizer.nextToken();
            selectedItemLabels.add(selectedItem);
        }
        this.setSelectedItems(selectedItemLabels);
    }

    private void clearSelection() {
        this.myListSelectionModel.clearSelection();
        this.myHasNonExistingSelection = false;
    }

    @Override
    public Component getEditor() {
        if (this.myEditor == null) {
            this.myEditor = this.createEditor();
            this.addVariableChangeListener(this.myEditor);
        }
        return this.myEditor;
    }

    protected ListVariableEditor<T> createEditor() {
        return new ListVariableEditor<T>(this.myEditIsAllowed, this.myItems, this.myLabeler, this.myListSelectionModel, this.isValueValid());
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myEditor != null;
    }

    @Override
    public boolean isValueValid() {
        boolean hasSelection = !this.myListSelectionModel.isSelectionEmpty();
        return !this.myHasNonExistingSelection && (hasSelection || !this.myMustHaveSelection);
    }

    @Override
    public Component getRenderer() {
        return new JLabel(this.getValueString());
    }

    @Override
    protected void writeXMLVarSpecific(PrintWriter out) {
    }

    @Override
    public Object getModel() {
        return this.myListSelectionModel;
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && !ListVariable.this.myIsSettingSelection) {
                ListVariable.this.fireValueChanged();
            }
        }
    }

    private static class ToStringLabeler<U>
    implements TypedDropDownVariable.ItemLabeler<U> {
        private ToStringLabeler() {
        }

        @Override
        public String getDisplayStringFor(U object, int index) {
            return String.valueOf(object);
        }
    }
}

