/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.variable.FilterableTypedDropDownVariable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class LazyFieldDropDownVariable
extends FilterableTypedDropDownVariable<FieldHierarchyNode> {
    private final AvailableFieldListBuilder myBuilder;
    private final String myFirstChoiceName;

    @Override
    public boolean isValueValid() {
        boolean valid = this.editorHasBeenCreated() ? super.isValueValid() : this.myBuilder.filtersAllow(LazyFieldDropDownVariable.findField(this.myBuilder, this.myFirstChoiceName));
        return valid;
    }

    @Override
    public Component getEditor() {
        boolean needsSetup;
        boolean bl = needsSetup = !this.editorHasBeenCreated();
        if (needsSetup) {
            this.setOptions(this.myBuilder.buildList());
        }
        Component component = super.getEditor();
        if (needsSetup) {
            FieldHierarchyNode choice = LazyFieldDropDownVariable.findField(this.myBuilder, this.myFirstChoiceName);
            if (choice != null) {
                this.setVarValue(choice);
            } else {
                this.setEditorText(this.myFirstChoiceName);
            }
        }
        return component;
    }

    public LazyFieldDropDownVariable(String label, AvailableFieldListBuilder builder, String choice) {
        super(label, LazyFieldDropDownVariable.createListFrom(builder, choice));
        this.myItemDisplayer = new FieldOrientedPluginProfileUtil.FieldDisplayer();
        this.myBuilder = builder;
        this.myFirstChoiceName = choice;
    }

    private static List<FieldHierarchyNode> createListFrom(AvailableFieldListBuilder builder, String choice) {
        LazyFieldDropDownVariable.checkNotNull(builder);
        ArrayList<FieldHierarchyNode> fieldList = new ArrayList<FieldHierarchyNode>();
        FieldHierarchyNode chosenField = builder.getClassRepository().getFieldRepository().getFieldByName(choice);
        if (chosenField != null) {
            fieldList.add(chosenField);
        }
        return fieldList;
    }

    private static FieldHierarchyNode findField(AvailableFieldListBuilder builder, String name) {
        return builder.getClassRepository().getFieldRepository().getFieldByName(name);
    }

    private static <T> T checkNotNull(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return value;
    }
}

