/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.selectiontree.util.FieldIndexFormatter;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.HierarchicalFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.ContainerVariable;
import ericsson.vareditor.variable.FieldUser;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class HierarchicalFieldVariable
extends ContainerVariable
implements FieldUser,
VariableChangeListener {
    private static final String INDEX_LABEL = "Index";
    private static final String USE_INDEX_LABEL = "Use index";
    private static final String FIELD_NAME = "Name";
    private boolean myIndexAllowed;
    private boolean myIndexMandatory;
    private boolean myMultiSelectAllowed;
    private List<FieldHierarchyNode> myChoices;
    private HierarchicalFieldCompositeObject myValue;
    private ClassRepository myRep;

    private HierarchicalFieldVariable(String label, HierarchicalFieldCompositeObject value, boolean index, boolean multi, boolean indexMandatory, List<FieldHierarchyNode> choices, ClassRepository rep) {
        super(label, null, new ArrayList<Variable>());
        this.myIndexAllowed = index;
        this.myIndexMandatory = indexMandatory;
        this.myMultiSelectAllowed = multi;
        this.myValue = value;
        this.myChoices = choices;
        this.myRep = rep;
        this.createVariables();
    }

    private void createVariables() {
        this.myVariables = new ArrayList();
        if (this.myValue != null) {
            this.buildWithStartValue();
        } else {
            this.buildWithoutStartValue();
        }
        for (Variable var : this.myVariables) {
            var.addVariableChangeListener(this);
        }
    }

    @Override
    public List<String> getReservedFields() {
        ArrayList<String> reservedFields = new ArrayList<String>();
        if (this.myValue != null) {
            reservedFields.addAll(this.myValue.getReservedFields());
        }
        return reservedFields;
    }

    private void addIndexVariableIfNeeded() {
        Variable useIndexVar = VarListUtil.getVariableForName(this.myVariables, USE_INDEX_LABEL);
        if (useIndexVar != null && useIndexVar.getValueObject() == Boolean.TRUE) {
            String name = VarListUtil.getVariableForName(this.myVariables, FIELD_NAME).getValueString();
            FieldHierarchyNode complexField = this.myRep.getFieldRepository().getFieldByName(name);
            this.myVariables.add(IndexVariableFactory.buildFactory().withHierarchicalFieldSupport(true).andRepository(this.myRep).createIndexVariableForField(INDEX_LABEL, INDEX_LABEL, complexField, this.myValue == null ? null : this.myValue.getIndexObject()));
        }
    }

    private void buildWithStartValue() {
        String fieldName = this.myValue.getFieldName();
        this.addFieldVariable(fieldName);
        this.addIndexCheckBoxIfNeeded(fieldName);
        this.addIndexVariableIfNeeded();
        this.addCheckBoxes();
    }

    private void buildWithoutStartValue() {
        this.addFieldVariable(this.myChoices.get(0).getCanonicalName());
        this.addIndexCheckBoxIfNeeded(this.myChoices.get(0).getCanonicalName());
        this.addIndexVariableIfNeeded();
        this.addCheckBoxes();
    }

    private void addCheckBoxes() {
        String name = VarListUtil.getVariableForName(this.myVariables, FIELD_NAME).getValueString();
        FieldHierarchyNode chosenField = this.myRep.getFieldRepository().getFieldByName(name);
        if (chosenField != null) {
            Variable indexVar = VarListUtil.getVariableForName(this.myVariables, USE_INDEX_LABEL);
            boolean useIndex = indexVar != null && (Boolean)indexVar.getValueObject() != false;
            FieldHierarchyNode.ComplexType type = chosenField.getComplexType();
            boolean childrenAllowed = true;
            if (type == FieldHierarchyNode.ComplexType.ARRAY || type == FieldHierarchyNode.ComplexType.MAP) {
                childrenAllowed = useIndex;
            } else if (type == FieldHierarchyNode.ComplexType.SET) {
                childrenAllowed = false;
            }
            if (!chosenField.isLeaf() && this.myMultiSelectAllowed && childrenAllowed) {
                List<FieldHierarchyNode> descendants = ((FieldStructure)chosenField).getAllDescendants();
                for (FieldHierarchyNode child : descendants) {
                    if (!child.isLeaf() || child.isKey()) continue;
                    boolean selected = this.myValue != null && this.myValue.getChildren().contains(child);
                    String subName = child.getCanonicalName().substring(name.length() + 1);
                    BoolVariable var = new BoolVariable(subName, selected);
                    this.myVariables.add(var);
                }
            }
        }
    }

    private void addFieldVariable(String fieldName) {
        this.myVariables.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(FIELD_NAME, null, this.myChoices, fieldName));
    }

    private void addIndexCheckBoxIfNeeded(String fieldName) {
        FieldHierarchyNode chosenField = this.myRep.getFieldRepository().getFieldByName(fieldName);
        if (chosenField != null) {
            boolean canUseIndex;
            FieldHierarchyNode.ComplexType type = chosenField.getComplexType();
            FieldStructure parent = chosenField.getParent();
            FieldHierarchyNode.ComplexType parentType = parent != null ? parent.getComplexType() : null;
            boolean indexDemandedByParent = parentType == FieldHierarchyNode.ComplexType.ARRAY || parentType == FieldHierarchyNode.ComplexType.MAP;
            boolean bl = canUseIndex = indexDemandedByParent || type == FieldHierarchyNode.ComplexType.ARRAY || type == FieldHierarchyNode.ComplexType.MAP;
            if (canUseIndex && (this.myIndexAllowed || indexDemandedByParent)) {
                boolean useIndex = this.myIndexMandatory || indexDemandedByParent || this.myValue != null && this.myValue.getIndexObject() != null;
                BoolVariable var = new BoolVariable(USE_INDEX_LABEL, useIndex);
                if (this.myIndexMandatory || indexDemandedByParent) {
                    var.setAllowEdit(false);
                }
                this.myVariables.add(var);
            }
        }
    }

    @Override
    public void valueChanged(VariableChangeEvent event) {
        Variable source = (Variable)event.getSource();
        Variable fieldVar = VarListUtil.getVariableForName(this.myVariables, FIELD_NAME);
        String label = source.getLabel();
        boolean change = false;
        for (Variable var : this.myVariables) {
            var.removeVariableChangeListener(this);
        }
        if (FIELD_NAME.equals(label)) {
            change = true;
            this.myVariables.clear();
            this.myVariables.add(fieldVar);
            String chosen = event.getSource().toString();
            this.addIndexCheckBoxIfNeeded(chosen);
            this.addIndexVariableIfNeeded();
            this.addCheckBoxes();
        } else if (USE_INDEX_LABEL.equals(label)) {
            change = true;
            Variable indexVar = VarListUtil.getVariableForName(this.myVariables, USE_INDEX_LABEL);
            this.myVariables.clear();
            this.myVariables.add(fieldVar);
            this.myVariables.add(indexVar);
            this.addIndexVariableIfNeeded();
            this.addCheckBoxes();
        } else if (INDEX_LABEL.equals(source.getKey())) {
            ((BaseVariable)source).fireValueChanged();
        }
        for (Variable var : this.myVariables) {
            var.addVariableChangeListener(this);
        }
        this.validate();
        this.setDataItem((Object)null);
        this.getPanelVariableEditor();
        if (change) {
            VarTable2 table = (VarTable2)((JPanel)((Object)this.myPanelVariableEditor)).getComponent(0);
            table.updateTable();
        }
    }

    @Override
    public String getValueString() {
        FieldIndexFormatter form = new FieldIndexFormatter(this.myRep.getFieldRepository().getFieldByName(VarListUtil.getValueStringForName(this.myVariables, FIELD_NAME)));
        ValueFieldCompositeObject obj = null;
        if (VarListUtil.getVariableForKey(this.myVariables, INDEX_LABEL) != null) {
            obj = (ValueFieldCompositeObject)VarListUtil.getVariableForKey(this.myVariables, INDEX_LABEL).getValueObject();
        }
        return form.format(this.myRep, obj);
    }

    @Override
    public Object getValueObject() {
        if (this.myPanelVariableEditor != null) {
            this.myValue = this.createValueObjectFromVariables();
        }
        return this.myValue;
    }

    private HierarchicalFieldCompositeObject createValueObjectFromVariables() {
        HierarchicalFieldCompositeObject obj = new HierarchicalFieldCompositeObject(VarListUtil.getValueStringForKey(this.myVariables, FIELD_NAME));
        Variable var = VarListUtil.getVariableForKey(this.myVariables, INDEX_LABEL);
        if (var != null) {
            obj.setIndexObject((ValueFieldCompositeObject)var.getValueObject());
        }
        return obj;
    }

    public static class HierarchicalFieldVariableBuilder {
        private boolean myIndexAllowed = true;
        private boolean myIndexMandatory = false;
        private boolean myMultipleSelectionAllowed = false;
        private List<FieldHierarchyNode> myChoices = new ArrayList<FieldHierarchyNode>();
        private ClassRepository myRep;
        private HierarchicalFieldCompositeObject myStartValue;

        private HierarchicalFieldVariableBuilder(ClassRepository rep) {
            this.myRep = rep;
        }

        public static HierarchicalFieldVariableBuilder builder(ClassRepository rep) {
            return new HierarchicalFieldVariableBuilder(rep);
        }

        public HierarchicalFieldVariableBuilder withoutIndexes() {
            this.myIndexAllowed = false;
            this.myIndexMandatory = false;
            return this;
        }

        public HierarchicalFieldVariableBuilder withIndexMandatory() {
            this.myIndexAllowed = true;
            this.myIndexMandatory = true;
            return this;
        }

        public HierarchicalFieldVariableBuilder withMultipleFieldSelection() {
            this.myMultipleSelectionAllowed = true;
            return this;
        }

        public HierarchicalFieldVariableBuilder withFieldChoices(List<FieldHierarchyNode> choices) {
            this.myChoices = choices;
            return this;
        }

        public HierarchicalFieldVariableBuilder withStartValue(HierarchicalFieldCompositeObject val) {
            this.myStartValue = val;
            return this;
        }

        public HierarchicalFieldVariable build() {
            return new HierarchicalFieldVariable("Field", this.myStartValue, this.myIndexAllowed, this.myMultipleSelectionAllowed, this.myIndexMandatory, this.myChoices, this.myRep);
        }
    }
}

