/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.datatype.ValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.components.GroupedArrayPanel;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.PlainCollectionVariable;
import java.awt.Component;

public class GroupedArrayVariable
extends PlainCollectionVariable {
    private GroupedArrayPanel myGroupedPanel;

    public GroupedArrayVariable(String label, Object[] value, String dataType) {
        super(label, new ArrayModel(value, null), (ValueResolver)DataType.lookup(dataType), FieldHierarchyNode.ComplexType.MAP);
    }

    public GroupedArrayVariable(String label, Object[] value, String dataType, boolean forceArrayEdit) {
        super(label, new ArrayModel(value, null), (ValueResolver)DataType.lookup(dataType), GroupedArrayVariable.editTypeToComplexType(forceArrayEdit));
    }

    public GroupedArrayVariable(String label, Object[] value, ValueResolver resolver, boolean forceArrayEdit) {
        super(label, new ArrayModel(value, null), resolver, GroupedArrayVariable.editTypeToComplexType(forceArrayEdit));
    }

    public GroupedArrayVariable(String label, Object[] valueArray, String[] columnNames, ValueResolver valueResolver) {
        super(label, new ArrayModel(valueArray, columnNames), valueResolver, FieldHierarchyNode.ComplexType.MAP);
    }

    public GroupedArrayVariable(GroupedArrayVariable v) {
        super(v.getLabel(), GroupedArrayVariable.cloneModel(v.getModel()), v.getValueResolver(), GroupedArrayVariable.editTypeToComplexType(v.getForceArrayEdit()));
        this.setObjectLabeler(v.getObjectLabeler());
        this.setVariableProducer(this.getVariableProducer());
    }

    private static FieldHierarchyNode.ComplexType editTypeToComplexType(boolean forceArrayEdit) {
        return forceArrayEdit ? FieldHierarchyNode.ComplexType.ARRAY : FieldHierarchyNode.ComplexType.MAP;
    }

    @Override
    public Object clone() {
        return new GroupedArrayVariable(this);
    }

    public GroupedArrayPanel getGroupedArrayPanel() {
        return this.myGroupedPanel;
    }

    @Override
    public Component getEditor() {
        if (this.myGroupedPanel == null) {
            ArrayModel model = this.getModel();
            this.myGroupedPanel = new GroupedArrayPanel(model, model.toArray(), this, this.isSelected);
        }
        return this.myGroupedPanel;
    }
}

