/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.swing.EDT;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.VariableUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DropDownVariable
extends BaseVariable
implements ActionListener {
    public static final int BY_INDEX = 1;
    public static final int BY_OBJECT = 2;
    protected Object[] myChoices = null;
    protected Object[] myChoiceValues = null;
    protected Object mySelectedItem = null;
    protected boolean useIndex = false;
    protected boolean useChoiceValue = false;
    protected JComboBox myRenderer = null;
    protected JComboBox myEditor = null;

    public DropDownVariable(String label) {
        super(label);
    }

    public DropDownVariable(String label, Object[] choices) {
        super(label);
        this.myChoices = Arrays.copyOf(choices, choices.length);
        this.setSelectedIndex(0);
    }

    public DropDownVariable(String label, Object selection, Object[] choices) {
        super(label);
        this.myChoices = Arrays.copyOf(choices, choices.length);
        this.setSelectedItem(selection);
    }

    public DropDownVariable(String label, int selectionIndex, Object[] choices) {
        super(label);
        this.myChoices = Arrays.copyOf(choices, choices.length);
        this.setSelectedIndex(selectionIndex);
        this.useIndex = true;
    }

    public DropDownVariable(String label, Object selection, int indexType, Object[] choices) {
        super(label);
        this.myChoices = Arrays.copyOf(choices, choices.length);
        if (indexType == 1) {
            this.useIndex = true;
            try {
                this.setSelectedIndex(Integer.valueOf((String)selection));
            }
            catch (NumberFormatException e) {
                this.setSelectedItem(selection);
            }
        } else if (indexType == 2) {
            this.setSelectedItem(selection);
        }
    }

    public DropDownVariable(String label, Object[] choices, Object[] choiceValues, Object selectedChoiceValue) {
        super(label);
        if (choices.length != choiceValues.length) {
            throw new IllegalArgumentException("Label and value array sizes must be equal");
        }
        this.myChoices = Arrays.copyOf(choices, choices.length);
        this.myChoiceValues = Arrays.copyOf(choiceValues, choiceValues.length);
        this.useChoiceValue = true;
        this.setSelectedItem(this.findChoiceByValue(selectedChoiceValue));
    }

    public DropDownVariable(DropDownVariable v) {
        super(v);
        this.myChoices = Arrays.copyOf(v.myChoices, v.myChoices.length);
        this.myChoiceValues = v.myChoiceValues != null ? Arrays.copyOf(v.myChoiceValues, v.myChoiceValues.length) : null;
        this.mySelectedItem = v.mySelectedItem;
        this.useIndex = v.useIndex;
        this.useChoiceValue = v.useChoiceValue;
    }

    @Override
    public Object clone() {
        return new DropDownVariable(this);
    }

    private Object findChoiceByValue(Object value) {
        if (this.useChoiceValue && this.myChoiceValues != null && this.myChoices != null) {
            for (int i = 0; i < this.myChoiceValues.length; ++i) {
                if (!this.myChoiceValues[i].equals(value)) continue;
                return this.myChoices[i];
            }
        }
        return value;
    }

    private Object findValueByChoice(Object choice) {
        if (this.myChoices != null && this.useChoiceValue && this.myChoiceValues != null) {
            for (int i = 0; i < this.myChoices.length; ++i) {
                if (!this.myChoices[i].equals(choice)) continue;
                return this.myChoiceValues[i];
            }
        }
        return choice;
    }

    @Override
    public Object getValueObject() {
        Object valueObject;
        if (this.myEditor != null) {
            if (this.useIndex) {
                valueObject = this.getSelectedIndexFromEditor();
            } else {
                Object selectedItem = this.getSelectedItemFromEditor();
                valueObject = this.useChoiceValue ? this.findValueByChoice(selectedItem) : selectedItem;
            }
        } else {
            valueObject = this.useIndex ? Integer.valueOf(this.extractIndexForSelectedItem()) : this.findValueByChoice(this.mySelectedItem);
        }
        return valueObject;
    }

    @Override
    public String getTypename() {
        if (this.useIndex) {
            return "Integer";
        }
        if (this.myChoices != null && this.myChoices instanceof String[]) {
            return "String";
        }
        return "Object";
    }

    @Override
    public Class<?> getValueClass() {
        if (this.useIndex) {
            return Integer.class;
        }
        if (this.myChoices != null && this.myChoices instanceof String[]) {
            return String.class;
        }
        return Object.class;
    }

    @Override
    public int getFormat() {
        if (this.useIndex) {
            return 3;
        }
        if (this.myChoices != null && this.myChoices instanceof String[]) {
            return 2;
        }
        return 99;
    }

    @Override
    public boolean isValueValid() {
        return this.extractIndexForSelectedItem() != -1;
    }

    @Override
    public Component getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new JComboBox<Object>(this.myChoices);
            this.setSelectedItemInEditor(this.myRenderer);
        }
        this.setCurrentEditableStateOnEditor(this.myRenderer);
        return this.myRenderer;
    }

    @Override
    public Component getEditor() {
        if (this.myEditor == null) {
            this.myEditor = this.createEditor();
            this.setSelectedItemInEditor(this.myEditor);
            this.myEditor.addActionListener(this);
        }
        this.setCurrentEditableStateOnEditor(this.myEditor);
        this.updateEditorBackground();
        return this.myEditor;
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myEditor != null;
    }

    @Override
    protected void setVarValue(Object v) {
        this.setSelectedItem(v);
    }

    @Override
    protected void setVarValue(String v) {
        this.setSelectedItem(v);
    }

    public void setDropDownChoices(Object[] c) {
        if (this.useChoiceValue && this.myChoiceValues != null && this.myChoiceValues.length != c.length) {
            throw new IllegalArgumentException("Array size must be equal to value array size");
        }
        this.myChoices = Arrays.copyOf(c, c.length);
        if (this.myEditor != null) {
            Object selectedItem = this.getSelectedItemFromEditor();
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.myEditor.getModel();
            model.removeAllElements();
            for (int i = 0; i < c.length; ++i) {
                model.addElement(c[i]);
            }
            this.setSelectedItem(selectedItem);
        } else {
            this.setSelectedIndex(0);
        }
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
        int i;
        for (i = 0; i < this.myChoices.length; ++i) {
            out.println("<Choice>" + XMLUtil.escape(this.myChoices[i].toString()) + "</Choice>");
        }
        if (this.useChoiceValue) {
            for (i = 0; i < this.myChoiceValues.length; ++i) {
                out.println("<ChoiceValues>" + XMLUtil.escape(this.myChoiceValues[i].toString()) + "</ChoiceValues>");
            }
        }
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        this.setKey(key);
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList<String> choiceValues = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            if ("Choice".equals(n.getNodeName())) {
                choices.add(XMLUtil.getFirstTextContent(n));
                continue;
            }
            if ("ChoiceValues".equals(n.getNodeName())) {
                choiceValues.add(XMLUtil.getFirstTextContent(n));
                continue;
            }
            System.out.println("Unknown node (not a Choice): " + node.getNodeName());
        }
        this.myChoices = format == 99 ? choices.toArray(new Object[choices.size()]) : choices.toArray(new String[choices.size()]);
        if (format == 3) {
            this.setSelectedIndex(Integer.parseInt(value));
            this.useIndex = true;
        } else {
            this.setSelectedItem(value);
            this.useIndex = false;
        }
    }

    public void setSelectedIndex(int i) {
        this.mySelectedItem = i >= 0 && i < this.myChoices.length ? this.myChoices[i] : null;
        if (this.myEditor != null) {
            this.setSelectedItemInEditor(this.myEditor);
        }
        this.updateEditorBackground();
    }

    public int getSelectedIndex() {
        return this.extractIndexForSelectedItem();
    }

    public void setSelectedItem(Object o) {
        this.mySelectedItem = this.findChoiceByValue(o);
        if (this.myEditor != null) {
            this.setSelectedItemInEditor(this.myEditor);
            this.updateEditorBackground();
        }
    }

    public Object getSelectedItem() {
        int index = this.extractIndexForSelectedItem();
        if (index == -1) {
            return this.getValueObject();
        }
        return this.myChoices[index];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object selectedItem = this.getSelectedItemFromEditor();
        if (this.mySelectedItem != selectedItem) {
            this.mySelectedItem = selectedItem;
            this.fireValueChanged();
            this.updateEditorBackground();
        }
    }

    private void updateEditorBackground() {
        if (this.myEditor != null) {
            EDT.runAndWait(new Runnable(){

                @Override
                public void run() {
                    DropDownVariable.this.myEditor.setBackground(DropDownVariable.this.isValueValid() ? UIManager.getColor("ComboBox.background") : Color.RED);
                }
            });
        }
    }

    private void setSelectedItemInEditor(final JComboBox editor) {
        final int index = this.extractIndexForSelectedItem();
        final Object item = this.mySelectedItem;
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                if (DropDownVariable.this.useIndex || index != -1) {
                    editor.setSelectedIndex(index);
                } else {
                    editor.setEditable(true);
                    editor.setSelectedItem(item);
                    editor.setEditable(false);
                }
            }
        });
    }

    private Object getSelectedItemFromEditor() {
        final JComboBox editor = this.myEditor;
        return this.runOnEDT(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return editor.getSelectedItem();
            }
        });
    }

    private int getSelectedIndexFromEditor() {
        final JComboBox editor = this.myEditor;
        Object intObject = this.runOnEDT(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return editor.getSelectedIndex();
            }
        });
        return (Integer)intObject;
    }

    private Object runOnEDT(Callable<Object> callable) {
        try {
            return EDT.runAndWait(callable);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new AssertionError((Object)ex);
        }
    }

    private void setCurrentEditableStateOnEditor(final JComboBox editor) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                editor.setEnabled(DropDownVariable.this.myEditIsAllowed);
            }
        });
    }

    private JComboBox createEditor() {
        final Object[] choices = this.myChoices;
        return (JComboBox)this.runOnEDT(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JComboBox<Object> editor = new JComboBox<Object>(choices);
                editor.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                editor.setRenderer(VariableUtil.createDropDownRenderer(DropDownVariable.this, Color.red));
                return editor;
            }
        });
    }

    private int extractIndexForSelectedItem() {
        if (this.mySelectedItem != null && this.myChoices != null) {
            for (int i = 0; i < this.myChoices.length; ++i) {
                if (!this.mySelectedItem.equals(this.myChoices[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public String getValueString() {
        return this.getValueObject().toString();
    }

    @Override
    public String toString() {
        Object selectedItem = this.getSelectedItem();
        return selectedItem == null ? "" : selectedItem.toString();
    }
}

