/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.variable.BaseVariable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JCheckBox;
import org.w3c.dom.Node;

public class BoolVariable
extends BaseVariable
implements ActionListener {
    protected boolean myValue;
    protected JCheckBox myRenderer = null;
    protected JCheckBox myEditor = null;

    public BoolVariable(String label, boolean value) {
        super(label);
        this.myValue = value;
    }

    public BoolVariable(BoolVariable v) {
        super(v);
        this.myValue = v.myValue;
    }

    @Override
    public Object clone() {
        return new BoolVariable(this);
    }

    @Override
    public Object getValueObject() {
        return this.myValue;
    }

    @Override
    public String getTypename() {
        return "Boolean";
    }

    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    @Override
    public int getFormat() {
        return 1;
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public Component getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new JCheckBox();
        }
        this.myRenderer.setSelected(this.myValue);
        this.myRenderer.setEnabled(this.myEditIsAllowed);
        return this.myRenderer;
    }

    @Override
    public Component getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new JCheckBox();
            this.myEditor.addActionListener(this);
        }
        this.myEditor.setSelected(this.myValue);
        this.myEditor.setEnabled(this.myEditIsAllowed);
        return this.myEditor;
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myEditor != null;
    }

    @Override
    protected void setVarValue(Object v) {
        if (v instanceof Boolean) {
            this.myValue = (Boolean)v;
            if (this.myEditor != null) {
                this.myEditor.setSelected(this.myValue);
            }
        } else {
            this.setVarValue(v.toString());
        }
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = Boolean.valueOf(v);
        if (this.myEditor != null) {
            this.myEditor.setSelected(this.myValue);
        }
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        this.setKey(key);
        this.setValue(value);
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.myValue = this.myEditor.isSelected();
        this.fireValueChanged();
    }
}

