/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import ericsson.vareditor.documents.UnsignedNumberDocument;
import java.math.BigInteger;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class UnsignedNumberListDocument
extends PlainDocument
implements FieldValidation {
    private BigInteger myMin = UnsignedNumberDocument.BIGINT_ZERO;
    private BigInteger myMax = UnsignedNumberDocument.MAX_ULONG;
    private char[] myTokenCharacters = null;
    private Pattern tokenSplitter;
    private boolean isRangeAllowed = false;
    private boolean isEnabled = true;

    public UnsignedNumberListDocument() {
        char[] theTokenCharacters = new char[]{' ', '-', ',', '\t', '\n', '\r', '\u0000'};
        this.myTokenCharacters = theTokenCharacters;
        this.tokenSplitter = Pattern.compile("\\D+");
        this.isRangeAllowed = true;
    }

    public UnsignedNumberListDocument(char[] theTokenCharacters, boolean theAllowRange) {
        this.myTokenCharacters = theTokenCharacters;
        this.tokenSplitter = Pattern.compile("\\D+");
        this.isRangeAllowed = theAllowRange;
    }

    public UnsignedNumberListDocument(BigInteger min, BigInteger max) {
        this.myMin = min;
        this.myMax = max;
    }

    public UnsignedNumberListDocument(BigInteger min, BigInteger max, boolean theAllowRange) {
        this.myMin = min;
        this.myMax = max;
        this.isRangeAllowed = theAllowRange;
    }

    public UnsignedNumberListDocument(BigInteger min, BigInteger max, char[] theAllowedValues, boolean theAllowRange) {
        this.myMin = min;
        this.myMax = max;
        this.myTokenCharacters = theAllowedValues;
        this.tokenSplitter = Pattern.compile("\\D+");
        this.isRangeAllowed = theAllowRange;
    }

    public BigInteger getMinValue() {
        return this.myMin;
    }

    public void setMinValue(BigInteger v) {
        this.myMin = v;
    }

    public BigInteger getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(BigInteger v) {
        this.myMax = v;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        StringBuffer numbersOnlyString = new StringBuffer(str.length());
        int start = 0;
        if (UnsignedNumberListDocument.isNegative(this.myMin) && str.startsWith("-") && offs == 0) {
            numbersOnlyString.append("-");
            start = 1;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                numbersOnlyString.append(chars[i]);
                continue;
            }
            if (this.isAllowedValue(chars[i])) {
                numbersOnlyString.append(chars[i]);
                continue;
            }
            if (chars[i] == '-' && this.isRangeAllowed) {
                numbersOnlyString.append(chars[i]);
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            String aString = "";
            for (char cha : this.myTokenCharacters) {
                if (Character.isWhitespace(cha) || cha == ' ' || Character.getType(cha) == 15) continue;
                aString = aString.concat(",'" + String.valueOf(cha) + "'");
            }
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9' " + aString + " allowed");
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (proposedResult.equals("-")) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Can not start with '-'");
            return;
        }
        try {
            if (this.myTokenCharacters != null) {
                String[] tokenArr = this.tokenSplitter.split(proposedResult);
                for (int ii = 0; ii < tokenArr.length; ++ii) {
                    if (!tokenArr[ii].matches("\\d+")) continue;
                    this.checkValue(tokenArr[ii]);
                }
            } else {
                this.checkValue(proposedResult);
            }
            super.insertString(offs, numbersOnlyString.toString(), a);
        }
        catch (NumberFormatException e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
        }
    }

    private boolean isAllowedValue(char c) {
        if (this.myTokenCharacters != null) {
            for (int i = 0; i < this.myTokenCharacters.length; ++i) {
                if (this.myTokenCharacters[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    private void handleRange(String aRange, int aIndexOfRange) throws NumberFormatException {
        if (aRange.trim().equals("-")) {
            throw new NumberFormatException("Range can not be empty ");
        }
        if (aIndexOfRange == 0) {
            aIndexOfRange = aRange.substring(1).indexOf(45);
        }
        String startStr = aRange.substring(0, aIndexOfRange);
        String endStr = aRange.substring(aIndexOfRange + 1);
        this.withinRange(new BigInteger(startStr));
        if (endStr.trim().length() > 0) {
            this.withinRange(new BigInteger(endStr));
        }
    }

    private void withinRange(BigInteger aValue) throws NumberFormatException {
        if (this.isGreaterThanMax(aValue) || this.isLessThanMin(aValue)) {
            throw new NumberFormatException("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
        }
    }

    private void checkValue(String aValue) throws NumberFormatException {
        try {
            BigInteger proposedResult = new BigInteger(aValue);
            this.withinRange(proposedResult);
        }
        catch (NumberFormatException e) {
            if (e.getMessage().startsWith("Number out of range")) {
                throw e;
            }
            int indexOfRange = aValue.indexOf(45);
            if (indexOfRange != -1 && this.isRangeAllowed) {
                this.handleRange(aValue, indexOfRange);
            }
            throw e;
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            if (this.myTokenCharacters != null) {
                StringTokenizer token = new StringTokenizer(value, new String(this.myTokenCharacters));
                while (token.hasMoreTokens()) {
                    String currentToken = token.nextToken();
                    this.checkValue(currentToken);
                }
                return true;
            }
            this.checkValue(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    private static boolean isNegative(BigInteger valueToCheck) {
        return valueToCheck.compareTo(UnsignedNumberDocument.BIGINT_ZERO) == -1;
    }

    private boolean isGreaterThanMax(BigInteger valueToCheck) {
        return valueToCheck.compareTo(this.myMax) > 0;
    }

    private boolean isLessThanMin(BigInteger valueToCheck) {
        return valueToCheck.compareTo(this.myMin) < 0;
    }
}

