/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.math.BigInteger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class UnsignedNumberDocument
extends PlainDocument
implements FieldValidation {
    public static final BigInteger MAX_ULONG = new BigInteger("9223372036854775807").multiply(new BigInteger("2")).add(new BigInteger("1"));
    public static final BigInteger MAX_UINT = new BigInteger("2147483647").multiply(new BigInteger("2")).add(new BigInteger("1"));
    public static final BigInteger MAX_USHORT = new BigInteger("32767").multiply(new BigInteger("2")).add(new BigInteger("1"));
    public static final BigInteger BIGINT_ZERO = new BigInteger("0");
    private BigInteger myMin = BIGINT_ZERO;
    private BigInteger myMax = MAX_ULONG;
    private boolean allowEmpty = false;
    private boolean isEnabled = true;

    public UnsignedNumberDocument() {
    }

    public UnsignedNumberDocument(BigInteger min, BigInteger max) {
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = false;
    }

    public UnsignedNumberDocument(BigInteger min, BigInteger max, boolean empty) {
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = empty;
    }

    public BigInteger getMinValue() {
        return this.myMin;
    }

    public void setMinValue(BigInteger v) {
        this.myMin = v;
    }

    public BigInteger getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(BigInteger v) {
        this.myMax = v;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        String numbersOnlyString = "";
        int start = 0;
        if (UnsignedNumberDocument.isNegative(this.myMin) && str.startsWith("-") && offs == 0) {
            numbersOnlyString = numbersOnlyString + "-";
            start = 1;
        }
        if (str != null && str.length() > 0) {
            char[] chars = str.toCharArray();
            for (int i = start; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) {
                    numbersOnlyString = numbersOnlyString + chars[i];
                    continue;
                }
                RmaDefs.getInstance().controlledBeep();
                StatusPanel.getInstance().setStatusMsg("Only digits '0-9' allowed");
            }
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0 && this.allowEmpty) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        if (proposedResult.length() == 0) {
            return;
        }
        if (proposedResult.equals("-")) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        try {
            BigInteger bigIntProposedResult = new BigInteger(proposedResult);
            if (bigIntProposedResult.compareTo(this.myMax) == -1 || bigIntProposedResult.compareTo(this.myMax) == 0) {
                super.insertString(offs, numbersOnlyString, a);
            } else {
                RmaDefs.getInstance().controlledBeep();
                StatusPanel.getInstance().setStatusMsg("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
            }
        }
        catch (NumberFormatException e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
        }
    }

    @Override
    public boolean isValid(String value) {
        try {
            if (value.equals("")) {
                return this.allowEmpty;
            }
            BigInteger longProposedResult = new BigInteger(value);
            if (this.isLessThanOrEqualToMax(longProposedResult) && this.isGreaterThanOrEqualToMin(longProposedResult)) {
                return true;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Number out of range, must be within " + this.myMin + " >= " + longProposedResult + "<= " + this.myMax);
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    private static boolean isNegative(BigInteger valueToCheck) {
        return valueToCheck.compareTo(BIGINT_ZERO) == -1;
    }

    private boolean isLessThanOrEqualToMax(BigInteger valueToCheck) {
        return valueToCheck.compareTo(this.myMax) <= 0;
    }

    private boolean isGreaterThanOrEqualToMin(BigInteger valueToCheck) {
        return valueToCheck.compareTo(this.myMin) >= 0;
    }
}

