/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class StringDocument
extends PlainDocument
implements FieldValidation {
    private final boolean myAllowEmpty;
    private final int myMax;
    private StatusInterface myStatusHandler = new RMAStatusInterface();
    private boolean myIsEnabled = true;

    public StringDocument(long max) {
        this(max, true);
    }

    public StringDocument(boolean shouldAllowEmpty) {
        this(Integer.MAX_VALUE, shouldAllowEmpty);
    }

    public StringDocument(long max, boolean shouldAllowEmpty) {
        this.myMax = (int)max;
        this.myAllowEmpty = shouldAllowEmpty;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.myIsEnabled = enable;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (this.myIsEnabled && proposedResult.length() > this.myMax) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Length of the text is too long, can be a maximum of " + this.myMax + " characters.");
            return;
        }
        this.myStatusHandler.printMessage("");
        super.insertString(offs, str, a);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        boolean removeToEmpty;
        boolean bl = removeToEmpty = offs == 0 && len == this.getLength();
        if (this.myIsEnabled && !this.myAllowEmpty && removeToEmpty) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("The text cannot be an empty string.");
        }
        super.remove(offs, len);
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() > this.myMax) {
            return false;
        }
        return this.myAllowEmpty || value.length() != 0;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatusHandler = statusHandler;
    }
}

