/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import ericsson.vareditor.variable.RelativeTime;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RelativeTimeDocument
extends PlainDocument
implements FieldValidation {
    private boolean isEnabled = true;
    private RelativeTime myMin;
    private RelativeTime myMax;
    private String myRegExpString = "([0-9]{1,4}):([0-5]?[0-9]):([0-5]?[0-9])";
    private final int MAX_CHAR_VALUE = 11;
    private final int MAX_RELATIVE_HOURS = 8759;

    public RelativeTimeDocument(RelativeTime min, RelativeTime max) {
        this.myMin = min;
        this.myMax = max;
    }

    private boolean isValueInRange(RelativeTime value) {
        return value.compareTo(this.myMin) >= 0 && value.compareTo(this.myMax) <= 0;
    }

    @Override
    public boolean isValid(String value) {
        Pattern matcher = Pattern.compile(this.myRegExpString);
        RelativeTime relativeTime = RelativeTime.parseRelativeTime(value);
        return matcher.matcher(value).matches() && relativeTime != null && this.isValueInRange(relativeTime);
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        StatusPanel.getInstance().setStatusMsg("");
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String stringToInsert = str;
        char[] chars = stringToInsert.toCharArray();
        if (offs == 0) {
            while (chars.length > 0 && chars[0] == ' ') {
                stringToInsert = stringToInsert.substring(1);
                chars = stringToInsert.toCharArray();
            }
        }
        String currentString = this.getText(0, this.getLength());
        String statusMessage = "";
        boolean shouldInsert = false;
        boolean shouldBeep = false;
        if (this.containsAllowedChars(chars) && currentString.length() + chars.length < 11) {
            String beforeOffset = currentString.substring(0, offs);
            String afterOffset = currentString.substring(offs, currentString.length());
            String proposedResult = beforeOffset + stringToInsert + afterOffset;
            if (this.isValid(proposedResult)) {
                shouldInsert = true;
            } else if (this.stringContainsMoreThanTwoColons(proposedResult)) {
                statusMessage = "Format: HHHH:mm:ss";
            } else {
                statusMessage = "Format: HHHH:mm:ss within the range " + this.myMin.toString() + " - " + this.myMax.toString();
                shouldInsert = true;
            }
        } else {
            statusMessage = "Only digits 0-9, and ':' allowed. Format: HHHH:mm:ss";
            shouldBeep = true;
        }
        if (shouldBeep) {
            RmaDefs.getInstance().controlledBeep();
        }
        StatusPanel.getInstance().setStatusMsg(statusMessage);
        if (shouldInsert) {
            super.insertString(offs, stringToInsert, a);
        }
    }

    private boolean stringContainsMoreThanTwoColons(String proposedString) {
        int firstColonIndex = proposedString.indexOf(":");
        int lastColonIndex = proposedString.lastIndexOf(":");
        return firstColonIndex != -1 && lastColonIndex != -1 && firstColonIndex != lastColonIndex && proposedString.substring(firstColonIndex + 1, lastColonIndex).contains(":");
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    protected boolean containsAllowedChars(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i]) || chars[i] == ':') continue;
            return false;
        }
        return true;
    }

    private boolean isSecondsAndMinutesValid(String stringToCheck) {
        String regExp = "([0-9]{1,4}):([0-9]?[0-9]):([0-9]?[0-9])";
        Pattern matcher = Pattern.compile(regExp);
        if (matcher.matcher(stringToCheck).matches()) {
            String[] split = stringToCheck.split(":");
            int minute = Integer.parseInt(split[1]);
            int seconds = Integer.parseInt(split[2]);
            return minute <= 59 && seconds <= 59;
        }
        return false;
    }
}

