/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RegularExpressionMatcherDocument
extends PlainDocument
implements FieldValidation {
    private static final Pattern NUMERIC_STRING = Pattern.compile("\\d+");
    private Pattern myRegExpMatcher;
    private boolean isEnabled = true;
    private BigInteger myMin;
    private BigInteger myMax;
    private StatusInterface myStatusHandler = new RMAStatusInterface();

    public RegularExpressionMatcherDocument(String theRegExp) {
        this(theRegExp, false);
    }

    public RegularExpressionMatcherDocument(String theRegExp, boolean caseSensitive) {
        this.myRegExpMatcher = Pattern.compile(theRegExp, caseSensitive ? 0 : 2);
    }

    public RegularExpressionMatcherDocument(String theRegExp, BigInteger min, BigInteger max) {
        this(theRegExp, min, max, false);
    }

    public RegularExpressionMatcherDocument(String theRegExp, BigInteger min, BigInteger max, boolean caseSensitive) {
        this(theRegExp, caseSensitive);
        this.myMin = min;
        this.myMax = max;
    }

    public RegularExpressionMatcherDocument(Pattern regExpPattern) {
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        this.myStatusHandler.printMessage("");
        boolean shouldInsertString = false;
        if (this.isEnabled) {
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(offs, currentText.length());
            String proposedResult = beforeOffset + str + afterOffset;
            if (proposedResult.length() > 0) {
                Matcher m = this.myRegExpMatcher.matcher(proposedResult);
                if (m.matches()) {
                    if (this.hasBothMinAndMax()) {
                        BigInteger value = null;
                        try {
                            value = new BigInteger(proposedResult);
                            shouldInsertString = this.isValueWithinMinAndMax(value);
                        }
                        catch (NumberFormatException nfe) {
                            boolean isNumeric = NUMERIC_STRING.matcher(proposedResult).matches();
                            shouldInsertString = !isNumeric;
                        }
                    } else {
                        shouldInsertString = true;
                    }
                }
                if (!shouldInsertString) {
                    this.myStatusHandler.beep();
                    this.myStatusHandler.printMessage("The input " + proposedResult + " does not match the allowed format.");
                }
            }
        } else {
            shouldInsertString = true;
        }
        if (shouldInsertString) {
            super.insertString(offs, str, a);
        }
    }

    private boolean hasBothMinAndMax() {
        return this.myMin != null && this.myMax != null;
    }

    private boolean isValueWithinMinAndMax(BigInteger value) {
        return value.compareTo(this.myMin) >= 0 && value.compareTo(this.myMax) <= 0;
    }

    @Override
    public boolean isValid(String value) {
        boolean validationResult = false;
        if (this.isEnabled) {
            if (value != null) {
                Matcher m = this.myRegExpMatcher.matcher(value);
                validationResult = m.matches();
            }
        } else {
            validationResult = true;
        }
        return validationResult;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatusHandler = statusHandler;
    }
}

