/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

@Deprecated
public class NumberListDocument
extends PlainDocument
implements FieldValidation {
    private long myMin = Long.MIN_VALUE;
    private long myMax = Long.MAX_VALUE;
    private char[] mySeparatorCharacters = null;
    private boolean isRangeAllowed = false;
    private boolean isEnabled = true;
    private char[] myAllowedCharacters = null;

    public NumberListDocument() {
        char[] theSeparatorCharacters = new char[]{' ', '-', ',', '\t', '\n', '\r', '\u0000'};
        this.mySeparatorCharacters = theSeparatorCharacters;
        this.isRangeAllowed = true;
    }

    public NumberListDocument(char[] theTokenCharacters, boolean theAllowRange) {
        this.myAllowedCharacters = theTokenCharacters;
        this.isRangeAllowed = theAllowRange;
    }

    public NumberListDocument(long min, long max) {
        char[] theSeparatorCharacters = new char[]{' ', '-', ',', '\t', '\n', '\r', '\u0000'};
        this.mySeparatorCharacters = theSeparatorCharacters;
        this.myMin = min;
        this.myMax = max;
    }

    public NumberListDocument(long min, long max, boolean theAllowRange) {
        char[] theSeparatorCharacters = new char[]{' ', '-', ',', '\t', '\n', '\r', '\u0000'};
        this.mySeparatorCharacters = theSeparatorCharacters;
        this.myMin = min;
        this.myMax = max;
        this.isRangeAllowed = theAllowRange;
    }

    public NumberListDocument(long min, long max, char[] theSeparatorCharacters, boolean theAllowRange) {
        this.myMin = min;
        this.myMax = max;
        this.mySeparatorCharacters = theSeparatorCharacters;
        this.isRangeAllowed = theAllowRange;
    }

    public long getMinValue() {
        return this.myMin;
    }

    public void setMinValue(long v) {
        this.myMin = v;
    }

    public long getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(long v) {
        this.myMax = v;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        StringBuffer numbersOnlyString = new StringBuffer(str.length());
        int start = 0;
        if (this.myMin < 0L && str.startsWith("-") && offs == 0) {
            numbersOnlyString.append("-");
            start = 1;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                numbersOnlyString.append(chars[i]);
                continue;
            }
            if (this.isAllowedValue(chars[i])) {
                numbersOnlyString.append(chars[i]);
                continue;
            }
            if (chars[i] == '-' && this.isRangeAllowed) {
                char c;
                if (offs > 0) {
                    String allText = this.getText(0, this.getLength());
                    c = allText.charAt(offs - 1);
                } else {
                    c = str.charAt(0);
                }
                if (c == ',' || c == ' ' || c == '\n' || c == '-' || c == '\r' || c == '\t' || c == '\u0000') {
                    RmaDefs.getInstance().controlledBeep();
                    StatusPanel.getInstance().setStatusMsg("Negative values are not allowed, ranges should be of the form 0-100");
                    return;
                }
                numbersOnlyString.append(chars[i]);
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            String retMessage = "";
            if (this.getTokenCharacters() != null) {
                retMessage = this.getTokenCharacters();
            }
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9' " + retMessage + " allowed");
            return;
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (proposedResult.equals("-")) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Can not start with '-'");
            return;
        }
        try {
            if (this.mySeparatorCharacters != null) {
                StringTokenizer token = new StringTokenizer(proposedResult, new String(this.mySeparatorCharacters));
                while (token.hasMoreTokens()) {
                    this.checkValue(token.nextToken(), true);
                }
            } else {
                this.checkValue(proposedResult, true);
            }
            super.insertString(offs, numbersOnlyString.toString(), a);
        }
        catch (NumberFormatException e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg(e.getMessage());
            return;
        }
    }

    private String getTokenCharacters() {
        String aString = "";
        for (char cha : this.mySeparatorCharacters) {
            if (Character.isWhitespace(cha) || cha == ' ' || Character.getType(cha) == 15) continue;
            aString = aString.concat(",'" + String.valueOf(cha) + "'");
        }
        return aString;
    }

    private boolean isAllowedValue(char c) {
        block3: {
            block2: {
                if (this.mySeparatorCharacters == null) break block2;
                for (int i = 0; i < this.mySeparatorCharacters.length; ++i) {
                    if (this.mySeparatorCharacters[i] != c) continue;
                    return true;
                }
                break block3;
            }
            if (this.myAllowedCharacters == null) break block3;
            for (int i = 0; i < this.myAllowedCharacters.length; ++i) {
                if (this.myAllowedCharacters[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> extractRangesFromString(String value) {
        String separators = null;
        ArrayList<String> theExtractedValues = new ArrayList<String>();
        if (this.mySeparatorCharacters != null) {
            separators = new String(this.mySeparatorCharacters);
            if (separators.contains("-")) {
                separators.replace("-", " ");
            }
        } else {
            char[] theSeparatorCharacters = new char[]{' ', ',', '\t', '\n', '\r', '\u0000'};
            separators = new String(theSeparatorCharacters);
        }
        StringTokenizer token = new StringTokenizer(value, separators);
        while (token.hasMoreTokens()) {
            theExtractedValues.add(token.nextToken());
        }
        return theExtractedValues;
    }

    private boolean handleRange(String aRange, int aIndexOfRange) throws NumberFormatException {
        int indexOfRange = aIndexOfRange;
        if (aRange.trim().equals("-") || aRange.trim().substring(0, 1).equals("-") || aRange.trim().substring(aRange.length() - 1, aRange.length()).equals("-")) {
            throw new NumberFormatException("Range can not be empty ");
        }
        if (indexOfRange == 0) {
            indexOfRange = aRange.substring(1).indexOf(45);
        }
        String startStr = aRange.substring(0, indexOfRange);
        String endStr = aRange.substring(indexOfRange + 1);
        long min = Long.valueOf(startStr);
        long max = 0L;
        this.withinRange(min);
        if (endStr.trim().length() > 0) {
            max = Long.valueOf(endStr);
            this.withinRange(max);
        }
        if (max < min) {
            throw new NumberFormatException("Min value needs to be less than max value in range");
        }
        return true;
    }

    private void withinRange(long aValue) throws NumberFormatException {
        if (aValue > this.myMax || aValue < this.myMin) {
            throw new NumberFormatException("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
        }
    }

    private boolean checkValue(String aValue, boolean allowIncompleteRange) throws NumberFormatException {
        try {
            long longProposedResult = Long.parseLong(aValue);
            this.withinRange(longProposedResult);
            return true;
        }
        catch (NumberFormatException e) {
            int indexOfRange = aValue.indexOf(45);
            if (aValue.contains("-") && this.isRangeAllowed) {
                if (allowIncompleteRange) {
                    return true;
                }
                if (indexOfRange != -1) {
                    if (this.handleRange(aValue, indexOfRange)) {
                        return true;
                    }
                    if (allowIncompleteRange) {
                        return true;
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            if (this.mySeparatorCharacters != null) {
                StringTokenizer token = new StringTokenizer(value, new String(this.mySeparatorCharacters));
                while (token.hasMoreTokens()) {
                    String currentToken = token.nextToken();
                    this.checkValue(currentToken, false);
                }
            } else {
                this.checkValue(value, false);
            }
            List<String> extractedValues = this.extractRangesFromString(value);
            for (String theValue : extractedValues) {
                if (!theValue.contains("-") || theValue.indexOf("-") == theValue.length()) continue;
                this.handleRange(theValue, theValue.indexOf("-"));
            }
            return true;
        }
        catch (NumberFormatException e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg(e.getMessage());
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

