/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.lang.reflect.Constructor;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class HexStringDocument
extends PlainDocument
implements FieldValidation {
    private static String hexOnly = "^(0[xX])?[0-9a-fA-F]*";
    private static Pattern hexPattern = Pattern.compile(hexOnly);
    private static Pattern myAllowedValuesPattern = null;
    private boolean isEnabled = true;
    Class<?> myValueClass;
    transient Constructor<?> myValueStringConstructor;
    char[] myAllowedValues = null;

    public HexStringDocument() {
        this.myValueClass = BcdString.class;
        this.initialize();
    }

    public HexStringDocument(Class<BcdString> c) {
        this.myValueClass = c;
        this.initialize();
    }

    public HexStringDocument(Class<?> c, char[] theAllowedValues) {
        this.myValueClass = c;
        this.myAllowedValues = theAllowedValues;
        this.initialize();
        this.createPatternForAllowedValues();
    }

    private void initialize() {
        try {
            this.myValueStringConstructor = this.myValueClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalArgumentException("String constructor not found for class: " + this.myValueClass);
        }
    }

    private void createPatternForAllowedValues() {
        String allowedValues = "^(0[xX])?[0-9a-fA-F";
        allowedValues = allowedValues.concat(String.valueOf(this.myAllowedValues) + "]*");
        myAllowedValuesPattern = Pattern.compile(allowedValues);
    }

    public boolean isHexDigit(char c) {
        if (c <= '9' && c >= '0') {
            return true;
        }
        if (c == 'a' || c == 'A') {
            return true;
        }
        if (c == 'b' || c == 'B') {
            return true;
        }
        if (c == 'c' || c == 'C') {
            return true;
        }
        if (c == 'd' || c == 'D') {
            return true;
        }
        if (c == 'e' || c == 'E') {
            return true;
        }
        if (c == 'f' || c == 'F') {
            return true;
        }
        if (this.myAllowedValues != null) {
            for (int i = 0; i < this.myAllowedValues.length; ++i) {
                if (this.myAllowedValues[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        String numbersOnlyString = "";
        int start = 0;
        int currLen = this.getLength();
        if (offs == 0 && currLen == 0) {
            if (str.startsWith("0x")) {
                numbersOnlyString = numbersOnlyString + "0x";
                start = 2;
            } else if (str.length() == 1 && str.charAt(0) == '0') {
                numbersOnlyString = numbersOnlyString + "0";
                start = 1;
            }
        }
        if (offs == 1 && currLen < 2 && str.length() != 0 && str.charAt(0) == 'x') {
            numbersOnlyString = numbersOnlyString + "x";
            start = 2;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (this.isHexDigit(chars[i])) {
                numbersOnlyString = numbersOnlyString + chars[i];
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            String aString = "";
            if (this.myAllowedValues != null) {
                for (char cha : this.myAllowedValues) {
                    if (Character.isWhitespace(cha) || cha == ' ' || Character.getType(cha) == 15) continue;
                    aString = aString.concat(",'" + String.valueOf(cha) + "'");
                }
            }
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9', 'a-f' " + aString + " allowed");
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        try {
            if (this.myValueStringConstructor == null) {
                this.initialize();
            }
            this.myValueStringConstructor.newInstance(proposedResult);
            super.insertString(offs, numbersOnlyString, a);
        }
        catch (Exception e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Illegal value: " + proposedResult + ", Details: " + e);
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (this.myAllowedValues != null) {
            return myAllowedValuesPattern.matcher(value).matches();
        }
        return hexPattern.matcher(value).matches();
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

