/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FloatsOnlyDocument
extends PlainDocument
implements FieldValidation {
    double myMin = Double.NEGATIVE_INFINITY;
    double myMax = Double.POSITIVE_INFINITY;
    Pattern myPattern = Pattern.compile("^(|-|-?[0-9]+\\.?[0-9]*[eE]-?[0-9]*)");
    private boolean isEnabled = true;
    private boolean allowEmpty;

    public FloatsOnlyDocument() {
        this.allowEmpty = false;
    }

    public FloatsOnlyDocument(double min, double max) {
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = false;
    }

    public FloatsOnlyDocument(double min, double max, boolean allowEmpty) {
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = allowEmpty;
    }

    public double getMinValue() {
        return this.myMin;
    }

    public void setMinValue(double v) {
        this.myMin = v;
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, 0, DocumentEvent.EventType.CHANGE));
    }

    public double getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(double v) {
        this.myMax = v;
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, 0, DocumentEvent.EventType.CHANGE));
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        String numbersOnlyString = "";
        int start = 0;
        if (str.startsWith("-") && offs == 0) {
            numbersOnlyString = numbersOnlyString + "-";
            start = 1;
        }
        char[] chars = str.toCharArray();
        String currentText = this.getText(0, this.getLength());
        boolean periodExists = currentText.indexOf(46) != -1;
        boolean exponentExists = currentText.indexOf(101) != -1;
        for (int i = start; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                numbersOnlyString = numbersOnlyString + chars[i];
                continue;
            }
            if (!(chars[i] != '.' && chars[i] != ',' || periodExists)) {
                numbersOnlyString = numbersOnlyString + ".";
                continue;
            }
            if (!(chars[i] != 'e' && chars[i] != 'E' || exponentExists)) {
                numbersOnlyString = numbersOnlyString + "e";
                continue;
            }
            if (chars[i] == '-' && numbersOnlyString.endsWith("e")) {
                numbersOnlyString = numbersOnlyString + "-";
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9' and '.' allowed");
            return;
        }
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (proposedResult.equals(".") || proposedResult.equals("-") || proposedResult.equals("-.")) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        int indexOfExponent = proposedResult.indexOf(101);
        if (indexOfExponent > -1) {
            String startStr = proposedResult.substring(0, indexOfExponent);
            String endStr = proposedResult.substring(indexOfExponent + 1);
            proposedResult = startStr + "e0" + endStr;
        }
        try {
            if (proposedResult.equalsIgnoreCase("1.7976931348623158e308") || proposedResult.equalsIgnoreCase("-1.7976931348623158e308") || proposedResult.equalsIgnoreCase("1.7976931348623158e+308") || proposedResult.equalsIgnoreCase("-1.7976931348623158e+308")) {
                RmaDefs.getInstance().controlledBeep();
                StatusPanel.getInstance().setStatusMsg("Number out of range (infinity) ");
            } else {
                double doubleProposedResult = Double.parseDouble(proposedResult);
                if (doubleProposedResult < Double.POSITIVE_INFINITY && doubleProposedResult > Double.NEGATIVE_INFINITY) {
                    super.insertString(offs, numbersOnlyString, a);
                } else if (doubleProposedResult == Double.POSITIVE_INFINITY || doubleProposedResult == Double.NEGATIVE_INFINITY) {
                    RmaDefs.getInstance().controlledBeep();
                    StatusPanel.getInstance().setStatusMsg("Number out of range (infinity) ");
                } else {
                    RmaDefs.getInstance().controlledBeep();
                    StatusPanel.getInstance().setStatusMsg("Only digits '0-9' and '.' allowed");
                }
            }
        }
        catch (NumberFormatException e) {
            if (this.myPattern.matcher(proposedResult).matches()) {
                super.insertString(offs, str, a);
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9' and '.' allowed");
        }
    }

    @Override
    public boolean isValid(String value) {
        try {
            if (value.equals("") && this.allowEmpty) {
                return true;
            }
            if (value.equalsIgnoreCase("1.7976931348623158e308") || value.equalsIgnoreCase("-1.7976931348623158e308") || value.equalsIgnoreCase("1.7976931348623158e+308") || value.equalsIgnoreCase("-1.7976931348623158e+308")) {
                RmaDefs.getInstance().controlledBeep();
                StatusPanel.getInstance().setStatusMsg("Number out of range (infinity) ");
                return false;
            }
            char[] chars = value.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == 'f') {
                    return false;
                }
                if (chars[i] == 'F') {
                    return false;
                }
                if (chars[i] == 'd') {
                    return false;
                }
                if (chars[i] != 'D') continue;
                return false;
            }
            double d = Double.parseDouble(value);
            if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                RmaDefs.getInstance().controlledBeep();
                StatusPanel.getInstance().setStatusMsg("Number out of range (infinity) ");
                return false;
            }
            if (d >= this.getMinValue() && d <= this.getMaxValue()) {
                return true;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Number out of range, must be within " + this.getMinValue() + " >= value <= " + this.getMaxValue());
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

