/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DigitStringListDocument
extends PlainDocument
implements FieldValidation {
    private static String numberExpression = "[0-9]+";
    private static Pattern numberPattern = Pattern.compile(numberExpression);
    char[] myTokenCharacters = new char[]{' ', ',', '\t', '\n', '\r'};
    private Pattern tokenSplitter = Pattern.compile("[" + new String(this.myTokenCharacters) + "]+");
    char[] myAllowedCharacters = null;
    private boolean isEnabled = true;

    public DigitStringListDocument() {
    }

    public DigitStringListDocument(char[] theAllowedCharacters) {
        this.myAllowedCharacters = theAllowedCharacters;
    }

    private boolean isAllowed(char c) {
        if (c <= '9' && c >= '0') {
            return true;
        }
        if (this.myAllowedCharacters != null) {
            for (int i = 0; i < this.myAllowedCharacters.length; ++i) {
                if (this.myAllowedCharacters[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTokenChar(char c) {
        if (this.myTokenCharacters != null) {
            for (int i = 0; i < this.myTokenCharacters.length; ++i) {
                if (this.myTokenCharacters[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        StringBuffer buf = new StringBuffer();
        int start = 0;
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (this.isAllowed(chars[i])) {
                buf.append(chars[i]);
                continue;
            }
            if (this.isTokenChar(chars[i])) {
                buf.append(chars[i]);
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9' and more allowed");
        }
        String numbersOnlyString = buf.toString();
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (this.myTokenCharacters != null) {
            String[] tokenArr = this.tokenSplitter.split(proposedResult);
            for (int ii = 0; ii < tokenArr.length; ++ii) {
                if (this.checkValue(tokenArr[ii], false)) continue;
                RmaDefs.getInstance().controlledBeep();
                StatusPanel.getInstance().setStatusMsg("Value " + tokenArr[ii] + " is not valid");
                return;
            }
        } else if (!this.checkValue(proposedResult, false)) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Value " + proposedResult + " not valid");
            return;
        }
        super.insertString(offs, numbersOnlyString.toString(), a);
    }

    private boolean checkNumber(String aNumber) {
        return numberPattern.matcher(aNumber).matches();
    }

    private boolean checkRange(String aValue, boolean rigid) {
        if (aValue.indexOf("-") >= 0) {
            String start = aValue.substring(0, aValue.indexOf("-"));
            String end = aValue.substring(aValue.indexOf("-") + 1, aValue.length());
            if (rigid) {
                return this.checkNumber(start) && this.checkNumber(end) && start.length() == end.length() && end.compareTo(start) > 0;
            }
            return !(start.length() != 0 && !this.checkNumber(start) || end.length() != 0 && !this.checkNumber(end));
        }
        return false;
    }

    private boolean checkValue(String aValue, boolean rigid) {
        if (aValue.indexOf("-") >= 0) {
            return this.checkRange(aValue, rigid);
        }
        return this.isValueAllowed(aValue.toCharArray());
    }

    private boolean isValueAllowed(char[] chars) {
        for (int ii = 0; ii < chars.length; ++ii) {
            if (this.isAllowed(chars[ii])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (this.myTokenCharacters != null) {
            String[] tokenArr = this.tokenSplitter.split(value);
            for (int ii = 0; ii < tokenArr.length; ++ii) {
                if (this.checkValue(tokenArr[ii], true)) continue;
                return false;
            }
        } else if (!this.checkValue(value, true)) {
            return false;
        }
        return true;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

