/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.lang.reflect.Constructor;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DigitStringDocument
extends PlainDocument
implements FieldValidation {
    private String exp = "[0-9]+";
    private String myStatusMsg = "'0-9'";
    Class<? extends String> myValueClass;
    transient Constructor<? extends String> myValueStringConstructor;
    char[] myAllowedValues;
    private boolean myAllowEmptyValue = false;
    private boolean isEnabled = true;

    public DigitStringDocument() {
        this.myValueClass = "".getClass();
        this.initialize();
    }

    public DigitStringDocument(Class<? extends String> c) {
        this.myValueClass = c;
        this.initialize();
    }

    public DigitStringDocument(Class<? extends String> c, char[] theAllowedValues, boolean allowEmptyValue) {
        this(c, theAllowedValues);
        this.myAllowEmptyValue = allowEmptyValue;
    }

    public DigitStringDocument(Class<? extends String> c, char[] theAllowedValues) {
        this.myValueClass = c;
        this.myAllowedValues = theAllowedValues;
        if (theAllowedValues.length > 0) {
            String temp = "[[0-9],";
            for (char curr : this.myAllowedValues) {
                temp = temp.concat("'" + String.valueOf(curr) + "',");
                this.myStatusMsg = this.myStatusMsg.concat(",'" + String.valueOf(curr) + "'");
            }
            this.exp = temp.substring(0, temp.length() - 1) + "]+";
        }
        this.initialize();
    }

    private void initialize() {
        try {
            this.myValueStringConstructor = this.myValueClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalArgumentException("String constructor not found for class: " + this.myValueClass);
        }
    }

    public boolean isDigit(char c) {
        if (c <= '9' && c >= '0') {
            return true;
        }
        if (this.myAllowedValues != null) {
            for (int i = 0; i < this.myAllowedValues.length; ++i) {
                if (this.myAllowedValues[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        StringBuffer buf = new StringBuffer();
        int start = 0;
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (this.isDigit(chars[i])) {
                buf.append(chars[i]);
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Only characters " + this.myStatusMsg + " allowed");
        }
        String numbersOnlyString = buf.toString();
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        try {
            if (this.myValueStringConstructor == null) {
                this.initialize();
            }
            this.myValueStringConstructor.newInstance(proposedResult);
            super.insertString(offs, numbersOnlyString, a);
        }
        catch (Exception e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Illegal value: " + proposedResult + ", Details: " + e);
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (this.myAllowEmptyValue && value.length() == 0) {
            return true;
        }
        Pattern pattern = Pattern.compile(this.exp);
        if (!pattern.matcher(value).matches()) {
            return false;
        }
        try {
            if (this.myValueStringConstructor == null) {
                this.initialize();
            }
            this.myValueStringConstructor.newInstance(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    public void setAllowEmptyValue(boolean allowEmpty) {
        this.myAllowEmptyValue = allowEmpty;
    }
}

