/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.gui.StatusPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AmountDocument
extends PlainDocument
implements FieldValidation {
    private boolean isEnabled = true;
    private boolean negativeInputAllowed = false;
    private boolean zeroAllowed = true;
    private RatingDecimal myMin = null;
    private RatingDecimal myMax = null;
    private int maxLength = Integer.MAX_VALUE;
    private int decimals = Integer.MAX_VALUE;
    private StatusInterface myStatusHandler = new RMAStatusInterface();

    public AmountDocument(boolean negativeInputAllowed) {
        this.negativeInputAllowed = negativeInputAllowed;
    }

    public AmountDocument(boolean negativeInputAllowed, boolean zeroAllowed) {
        this(negativeInputAllowed);
        this.zeroAllowed = zeroAllowed;
    }

    public AmountDocument(boolean negativeInputAllowed, boolean zeroAllowed, RatingDecimal min, RatingDecimal max, int maxLength, int decimals) {
        this(negativeInputAllowed, zeroAllowed);
        this.myMin = min;
        this.myMax = max;
        this.maxLength = maxLength;
        this.decimals = decimals;
    }

    public AmountDocument(String value, boolean negativeInputAllowed) {
        this.negativeInputAllowed = negativeInputAllowed;
    }

    public AmountDocument(String value, boolean negativeInputAllowed, boolean zeroAllowed) {
        this(value, negativeInputAllowed);
        this.zeroAllowed = zeroAllowed;
    }

    public AmountDocument(String value, boolean negativeInputAllowed, boolean zeroAllowed, RatingDecimal min, RatingDecimal max, int maxLength, int decimals) {
        this(value, negativeInputAllowed, zeroAllowed);
        this.myMin = min;
        this.myMax = max;
        this.maxLength = maxLength;
        this.decimals = decimals;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        StatusPanel.getInstance().setStatusMsg("");
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (proposedResult.length() > this.maxLength) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Amount cannot contain more than " + this.maxLength + " characters (including decimal sign)");
            return;
        }
        if (AmountDocument.decimalsIn(proposedResult) > this.decimals) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Maximum number of decimals allowed is " + this.decimals);
            return;
        }
        if (proposedResult.lastIndexOf("-") > 0) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Only digits '0-9' and '.' allowed");
            return;
        }
        if (!this.negativeInputAllowed && proposedResult.startsWith("-")) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Negative amounts not allowed");
            return;
        }
        if (proposedResult.equals("-") && this.negativeInputAllowed) {
            super.insertString(offs, str, a);
            return;
        }
        try {
            RatingDecimal valueObj = new RatingDecimal(proposedResult);
            if ((this.myMin == null || valueObj.isMoreThanOrEqual(this.myMin)) && (this.myMax == null || valueObj.isLessThanOrEqual(this.myMax))) {
                super.insertString(offs, str, a);
                return;
            }
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Submitted value is out of range");
            return;
        }
        catch (NumberFormatException e) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Only digits '0-9' and '.' allowed");
        }
        catch (ArithmeticException ae) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Submitted value is out of range");
        }
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isValid(String value) {
        if (value.isEmpty()) {
            return false;
        }
        if (value.equals("-")) {
            return false;
        }
        if (value.startsWith("-") && !this.negativeInputAllowed) {
            return false;
        }
        if (value.length() > this.maxLength) {
            return false;
        }
        if (AmountDocument.decimalsIn(value) > this.decimals) {
            return false;
        }
        try {
            RatingDecimal rd = new RatingDecimal(value);
            if (rd.isZero() && !this.zeroAllowed) {
                return false;
            }
            if (this.myMin != null && rd.isLessThan(this.myMin) || this.myMax != null && rd.isMoreThan(this.myMax)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        if (statusHandler != null) {
            this.myStatusHandler = statusHandler;
        }
    }

    private static int decimalsIn(String value) {
        int ptPos = value.indexOf(46);
        if (ptPos != -1) {
            return value.length() - ptPos - 1;
        }
        return 0;
    }
}

