/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SingleSidedBorder
extends AbstractBorder {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private int mySide;
    private Color myColor = Color.BLACK;
    private Insets myInsets;

    public SingleSidedBorder(int side) {
        this.mySide = side;
        this.myInsets = new Insets(1, 1, 1, 1);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.myColor);
        switch (this.mySide) {
            case 2: {
                g.drawLine(x, y, x + width - 1, y);
                break;
            }
            case 3: {
                int b = y + height - 1;
                g.drawLine(x, b, x + width - 1, b);
                break;
            }
            case 0: {
                g.drawLine(x, y, x, y + height - 1);
                break;
            }
            case 1: {
                int r = x + width - 1;
                g.drawLine(r, y, r, y + height - 1);
            }
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myInsets;
    }

    public void setInsets(Insets i) {
        this.myInsets = i;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.myInsets;
    }
}

