/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor;

import com.ericsson.ere.naming.AbstractSwingComponentNamer;
import com.ericsson.ere.naming.ComponentNamer;
import com.ericsson.vareditor.TitleRenderer;
import ericsson.vareditor.LabelRenderer2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VarTable2
extends JPanel
implements FocusListener,
PropertyChangeListener,
TableModelListener,
MouseWheelListener {
    protected JViewport myViewport;
    protected JSplitPane mySplitPane;
    protected JPanel myLabelPanel;
    protected JPanel myValuePanel;
    protected VarTableModel myModel;
    protected LabelRenderer2 mySelection;
    protected boolean myUseSelectable = false;
    private JScrollPane myLeftScroller;
    private JScrollPane myRightScroller;
    private ContainerNameUpdater myContainerNameUpdater = new ContainerNameUpdater();
    private ResizeListener myResizeListener = new ResizeListener();
    VarTableFocusTraversalPolicy varTableFocusTraversalPolicy = new VarTableFocusTraversalPolicy();
    private Component myFocusOwner;
    private TableTitleGenerator myTableTitleGenerator;
    private transient ComponentNamer myComponentNamer = new VarTable2ComponentNamer();
    private boolean myIsUpdatingTable = false;

    public VarTable2() {
        this(null, false, null);
    }

    public VarTable2(TableTitleGenerator titleGenerator) {
        this(null, false, titleGenerator);
    }

    public VarTable2(VarTableModel model) {
        this(model, false, null);
    }

    public VarTable2(VarTableModel model, TableTitleGenerator titleGenerator) {
        this(model, false, titleGenerator);
    }

    public VarTable2(VarTableModel model, boolean useSelectable) {
        this(model, useSelectable, null);
    }

    public VarTable2(VarTableModel model, boolean useSelectable, TableTitleGenerator titleGenerator) {
        super(new BorderLayout());
        this.myUseSelectable = useSelectable;
        this.myTableTitleGenerator = titleGenerator != null ? titleGenerator : new LegacyTitleGenerator();
        this.setupUI();
        if (model != null) {
            this.setTableModelImpl(model);
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("name")) {
                    VarTable2.this.updateComponentNames();
                }
            }
        });
    }

    private void setupUI() {
        this.mySplitPane = new JSplitPane(1, true);
        this.mySplitPane.setDividerSize(3);
        this.mySplitPane.setDividerLocation(150);
        this.mySplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mySplitPane.setResizeWeight(0.1);
        this.add((Component)this.mySplitPane, "Center");
        this.myLeftScroller = new JScrollPane(21, 31);
        this.myLeftScroller.setName("VarTable2.JScrollPane.LeftScroller");
        this.myRightScroller = new JScrollPane(20, 31);
        this.myRightScroller.setName("VarTable2.JScrollPane.RightScroller");
        this.myLeftScroller.setBorder(new EmptyBorder(0, 1, 0, 0));
        this.myRightScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.myLeftScroller.addMouseWheelListener(this);
        this.myRightScroller.addMouseWheelListener(this);
        JScrollBar sb1 = this.myLeftScroller.getVerticalScrollBar();
        JScrollBar sb2 = this.myRightScroller.getVerticalScrollBar();
        sb1.setUnitIncrement(10);
        sb2.setUnitIncrement(10);
        sb2.getModel().addChangeListener(new ScrollBarSynchronizer(sb1));
        sb1.getModel().addChangeListener(new ScrollBarSynchronizer(sb2));
        this.mySplitPane.setLeftComponent(this.myLeftScroller);
        this.mySplitPane.setRightComponent(this.myRightScroller);
        this.myValuePanel = new JPanel();
        this.myValuePanel.setLayout(new VarTableLayout(false));
        this.myRightScroller.setViewportView(this.myValuePanel);
        this.myViewport = this.myRightScroller.getViewport();
        this.myLabelPanel = new JPanel();
        this.myLabelPanel.setLayout(new VarTableLayout());
        this.myLeftScroller.setViewportView(this.myLabelPanel);
        this.mySplitPane.setDividerLocation(150);
    }

    public void setTableModel(VarTableModel model) {
        if (this.myModel != model) {
            if (this.myModel != null) {
                this.myModel.removeTableModelListener(this);
            }
            this.setTableModelImpl(model);
        }
    }

    private void setTableModelImpl(VarTableModel model) {
        this.myModel = model;
        this.myModel.addTableModelListener(this);
        this.updateTable(false, false);
    }

    public VarTableModel getTableModel() {
        return this.myModel;
    }

    public void updateTable() {
        this.updateTable(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(boolean forceAddComponents, boolean suppressRepaint) {
        boolean showing = this.isShowing();
        try {
            this.myIsUpdatingTable = true;
            this.myLabelPanel.removeAll();
            this.removeListeners(this.myValuePanel);
            this.myValuePanel.removeAll();
            if ((showing || forceAddComponents) && this.myModel != null) {
                int position = 0;
                for (Variable v : this.myModel.getData()) {
                    v.setFocusListenerForEditor(this);
                    JComponent label = this.myTableTitleGenerator.getTitleFor(v, this.myUseSelectable).getComponent();
                    this.myLabelPanel.add(label);
                    Component editor = v.getEditor();
                    this.addContainerListenerIfPossible(editor);
                    this.addResizeListener(editor);
                    this.myValuePanel.add(editor);
                    position = Math.max(position, label.getPreferredSize().width);
                }
                this.mySplitPane.setDividerLocation(position + 10);
                this.updateComponentNames();
            }
        }
        finally {
            this.myIsUpdatingTable = false;
            if (showing && !suppressRepaint) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    private boolean tableNeedsUpdating() {
        int cc = this.myLabelPanel.getComponentCount();
        return this.myModel != null && this.myModel.getRowCount() != cc;
    }

    private void addResizeListener(Component editor) {
        editor.addComponentListener(this.myResizeListener);
    }

    private void removeListeners(Container container) {
        for (Component c : container.getComponents()) {
            if (c instanceof Container) {
                ((Container)c).removeContainerListener(this.myContainerNameUpdater);
            }
            c.removeComponentListener(this.myResizeListener);
        }
    }

    private void addContainerListenerIfPossible(Component c) {
        if (c instanceof Container) {
            ((Container)c).addContainerListener(this.myContainerNameUpdater);
        }
    }

    private void updateComponentNames() {
        if (this.myValuePanel.getComponentCount() == 0) {
            return;
        }
        int count = this.myValuePanel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            String key = this.myModel.getData().get(i).getKey();
            Component c = this.myValuePanel.getComponent(i);
            String prefix = this.getName();
            prefix = prefix != null ? prefix + "." : "";
            prefix = prefix + this.myComponentNamer.normalizeName(key);
            this.myComponentNamer.setComponentName(c, prefix, 0);
        }
    }

    private int getComponentHeight(int i) {
        JComponent c = (JComponent)this.myValuePanel.getComponent(i);
        return c.getPreferredSize().height;
    }

    protected boolean isComponentVisible(int i) {
        JComponent c = (JComponent)this.myValuePanel.getComponent(i);
        return c.isVisible();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Component comp = (Component)e.getNewValue();
        if (comp != null) {
            Container parent = comp.getParent();
            Container child = (Container)comp;
            while (parent != null && parent != this.myValuePanel) {
                child = parent;
                parent = child.getParent();
            }
            if (parent != null) {
                FocusEvent f = new FocusEvent(child, 1004);
                this.focusGained(f);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Component c;
        for (c = focusEvent.getComponent(); c != null && c.getParent() != this.myValuePanel; c = c.getParent()) {
        }
        if (c instanceof JComponent) {
            Component lc;
            JComponent jc = (JComponent)c;
            Point pc = this.myViewport.getViewPosition();
            Point pn = jc.getLocation();
            int dy = pc.y - pn.y;
            Dimension dc = this.myViewport.getSize();
            Dimension dn = jc.getSize();
            int dhy = pc.y + dc.height - (pn.y + dn.height);
            if (dy != 0) {
                if (dy > 0) {
                    pc.y = pn.y;
                    this.myViewport.setViewPosition(pc);
                } else if (dhy < 0) {
                    int ty = pc.y - dhy;
                    pc.y = ty - pn.y > 0 ? pn.y : (pc.y -= dhy);
                    this.myViewport.setViewPosition(pc);
                }
            }
            if ((lc = this.myLabelPanel.getComponentAt(pn)) instanceof LabelRenderer2) {
                if (this.mySelection != null) {
                    this.mySelection.setDeselected();
                }
                this.mySelection = (LabelRenderer2)lc;
                this.mySelection.setSelected();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateTable(false, false);
    }

    @Deprecated
    public void useSelectable(boolean use) {
        this.setSelectable(use);
    }

    public void setSelectable(boolean selectable) {
        if (selectable != this.myUseSelectable) {
            this.myUseSelectable = selectable;
            if (this.myModel != null) {
                this.updateTable(false, false);
            }
        }
    }

    public boolean isSelectable() {
        return this.myUseSelectable;
    }

    public void setFocusOwner(Component owner) {
        this.myFocusOwner = owner;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent me) {
        this.dispatchEvent(SwingUtilities.convertMouseEvent(this.myLeftScroller, me, this.myFocusOwner));
        this.dispatchEvent(SwingUtilities.convertMouseEvent(this.myRightScroller, me, this.myFocusOwner));
    }

    @Override
    public void invalidate() {
        if (!this.myIsUpdatingTable) {
            this.myLabelPanel.invalidate();
            this.myValuePanel.invalidate();
        }
        super.invalidate();
    }

    @Override
    public void doLayout() {
        this.updateTableIfNecessary();
        super.doLayout();
    }

    @Override
    public Dimension getPreferredSize() {
        this.updateTableIfNecessary();
        return super.getPreferredSize();
    }

    private void updateTableIfNecessary() {
        if (this.tableNeedsUpdating()) {
            this.updateTable(true, true);
        }
    }

    public Dimension getActualPreferredSize() {
        this.updateTableIfNecessary();
        this.validate();
        Dimension valueDimension = new Dimension();
        Dimension labelDimension = new Dimension();
        Component[] valueComponents = this.myValuePanel.getComponents();
        Component[] labelComponents = this.myLabelPanel.getComponents();
        assert (valueComponents.length == labelComponents.length);
        for (int i = 0; i < valueComponents.length; ++i) {
            Dimension valueComponentPreferredSize = valueComponents[i].getPreferredSize();
            Dimension labelComponentPreferredSize = labelComponents[i].getPreferredSize();
            valueDimension.width = Math.max(valueDimension.width, valueComponentPreferredSize.width);
            labelDimension.width = Math.max(labelDimension.width, labelComponentPreferredSize.width);
            valueDimension.height += Math.max(valueComponentPreferredSize.height, labelComponentPreferredSize.height);
        }
        valueDimension.width += labelDimension.width + 10;
        return valueDimension;
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            VarTable2.this.myLabelPanel.revalidate();
            VarTable2.this.myLabelPanel.repaint();
        }
    }

    private class ContainerNameUpdater
    extends ContainerAdapter {
        private ContainerNameUpdater() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            VarTable2.this.updateComponentNames();
        }
    }

    private class VarTable2ComponentNamer
    extends AbstractSwingComponentNamer {
        private VarTable2ComponentNamer() {
        }

        @Override
        protected boolean shouldTraverseComponentChildren(Component c) {
            return !(c instanceof VarTable2);
        }
    }

    private static class LegacyTitleGenerator
    implements TableTitleGenerator {
        private LegacyTitleGenerator() {
        }

        @Override
        public TitleRenderer getTitleFor(Variable var, boolean isSelectable) {
            LabelRenderer2 label = isSelectable ? new LabelRenderer2(var, var.isAllowEdit()) : new LabelRenderer2(var.getLabel(), var.isAllowEdit());
            return label;
        }
    }

    public static interface TableTitleGenerator {
        public TitleRenderer getTitleFor(Variable var1, boolean var2);
    }

    protected class VarTableFocusTraversalPolicy
    extends FocusTraversalPolicy {
        protected VarTableFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            int index;
            if (aComponent == this.getLastComponent(aContainer)) {
                if (this.getFirstComponent(aContainer).isEnabled()) {
                    return this.getFirstComponent(aContainer);
                }
                return aComponent;
            }
            List<Variable> vars = VarTable2.this.myModel.getData();
            for (index = 0; index < vars.size() && ((BaseVariable)vars.get(index)).getDefaultFocusableEditor() != aComponent; ++index) {
            }
            ++index;
            while (index < vars.size()) {
                Component nextEditor = ((BaseVariable)vars.get(index)).getDefaultFocusableEditor();
                if (nextEditor.isEnabled()) {
                    return nextEditor;
                }
                ++index;
            }
            return aComponent;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            int index;
            if (aComponent == this.getFirstComponent(aContainer)) {
                if (this.getLastComponent(aContainer).isEnabled()) {
                    return this.getLastComponent(aContainer);
                }
                return aComponent;
            }
            List<Variable> vars = VarTable2.this.myModel.getData();
            for (index = 0; index < vars.size() && ((BaseVariable)vars.get(index)).getDefaultFocusableEditor() != aComponent; ++index) {
            }
            --index;
            while (index >= 0) {
                Component nextEditor = ((BaseVariable)vars.get(index)).getDefaultFocusableEditor();
                if (nextEditor.isEnabled()) {
                    return nextEditor;
                }
                --index;
            }
            return aComponent;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return this.getFirstComponent(aContainer);
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            List<Variable> vars = VarTable2.this.myModel.getData();
            if (vars.size() > 0) {
                return ((BaseVariable)vars.get(0)).getDefaultFocusableEditor();
            }
            return null;
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            List<Variable> vars = VarTable2.this.myModel.getData();
            if (vars.size() > 0) {
                return ((BaseVariable)vars.get(vars.size() - 1)).getDefaultFocusableEditor();
            }
            return null;
        }
    }

    class VarTableLayout
    implements LayoutManager {
        public static final int GAP = 6;
        private boolean usePreferredSize = true;

        public VarTableLayout() {
        }

        public VarTableLayout(boolean sizePreference) {
            this.usePreferredSize = sizePreference;
        }

        @Override
        public void addLayoutComponent(String str, Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets = target.getInsets();
                int maxwidth = target.getSize().width - (insets.left + insets.right);
                int nmembers = target.getComponentCount();
                int x = insets.left;
                int y = insets.top;
                for (int i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    if (!VarTable2.this.isComponentVisible(i)) continue;
                    int height = VarTable2.this.getComponentHeight(i);
                    m.setBounds(x, y, maxwidth, height + 6);
                    y += height + 6;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.layoutSize(target, false);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.layoutSize(target, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container target, boolean pref) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, 0);
                int nmembers = target.getComponentCount();
                for (int i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    if (!VarTable2.this.isComponentVisible(i)) continue;
                    Dimension d = pref ? m.getPreferredSize() : m.getMinimumSize();
                    int height = VarTable2.this.getComponentHeight(i);
                    dim.height += height + 6;
                    dim.width = Math.max(dim.width, d.width);
                }
                Insets insets = target.getInsets();
                dim.height += insets.top + insets.bottom;
                if (!this.usePreferredSize) {
                    dim.width = 10;
                } else if (dim.width > 150) {
                    dim.width = 150;
                }
                return dim;
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    static class ScrollBarSynchronizer
    implements ChangeListener {
        private JScrollBar msbScrollBar;

        public ScrollBarSynchronizer(JScrollBar destScroll) {
            this.msbScrollBar = destScroll;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            BoundedRangeModel sourceScroll = (BoundedRangeModel)e.getSource();
            int iSMin = sourceScroll.getMinimum();
            int iSMax = sourceScroll.getMaximum();
            int iSDiff = iSMax - iSMin;
            int iSVal = sourceScroll.getValue();
            int iDMin = this.msbScrollBar.getMinimum();
            int iDMax = this.msbScrollBar.getMaximum();
            int iDDiff = iDMax - iDMin;
            int iDVal = iSDiff != 0 ? (iSDiff == iDDiff ? iSVal : iDDiff * iSVal / iSDiff) : 0;
            this.msbScrollBar.setValue(iDMin + iDVal);
        }
    }
}

